/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.fabric.impl.tag.convention;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.AbstractMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalEnchantmentTags;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalBlockTags;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalItemTags;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3489;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConventionLogWarnings
implements ModInitializer {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConventionLogWarnings.class);
    private static final LogWarningMode LOG_LEGACY_WARNING_MODE = ConventionLogWarnings.setupLogWarningModeProperty();
    private static final Map<class_6862<?>, class_6862<?>> LEGACY_C_TAGS = Map.ofEntries(ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.MOVEMENT_RESTRICTED, ConventionalBlockTags.RELOCATION_NOT_SUPPORTED), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.QUARTZ_ORES, ConventionalBlockTags.QUARTZ_ORES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.WOODEN_BARRELS, ConventionalBlockTags.WOODEN_BARRELS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.SANDSTONE_BLOCKS, ConventionalBlockTags.SANDSTONE_BLOCKS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.SANDSTONE_STAIRS, ConventionalBlockTags.SANDSTONE_STAIRS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.SANDSTONE_SLABS, ConventionalBlockTags.SANDSTONE_SLABS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.RED_SANDSTONE_BLOCKS, ConventionalBlockTags.RED_SANDSTONE_BLOCKS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.RED_SANDSTONE_STAIRS, ConventionalBlockTags.RED_SANDSTONE_STAIRS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.RED_SANDSTONE_SLABS, ConventionalBlockTags.RED_SANDSTONE_SLABS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.UNCOLORED_SANDSTONE_BLOCKS, ConventionalBlockTags.UNCOLORED_SANDSTONE_BLOCKS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.UNCOLORED_SANDSTONE_STAIRS, ConventionalBlockTags.UNCOLORED_SANDSTONE_STAIRS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalBlockTags.UNCOLORED_SANDSTONE_SLABS, ConventionalBlockTags.UNCOLORED_SANDSTONE_SLABS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.QUARTZ_ORES, ConventionalItemTags.QUARTZ_ORES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.WOODEN_BARRELS, ConventionalItemTags.WOODEN_BARRELS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.SANDSTONE_BLOCKS, ConventionalItemTags.SANDSTONE_BLOCKS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.SANDSTONE_STAIRS, ConventionalItemTags.SANDSTONE_STAIRS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.SANDSTONE_SLABS, ConventionalItemTags.SANDSTONE_SLABS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.RED_SANDSTONE_BLOCKS, ConventionalItemTags.RED_SANDSTONE_BLOCKS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.RED_SANDSTONE_STAIRS, ConventionalItemTags.RED_SANDSTONE_STAIRS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.RED_SANDSTONE_SLABS, ConventionalItemTags.RED_SANDSTONE_SLABS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.UNCOLORED_SANDSTONE_BLOCKS, ConventionalItemTags.UNCOLORED_SANDSTONE_BLOCKS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.UNCOLORED_SANDSTONE_STAIRS, ConventionalItemTags.UNCOLORED_SANDSTONE_STAIRS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.BLACK_DYES, ConventionalItemTags.BLACK_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.BLUE_DYES, ConventionalItemTags.BLUE_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.BROWN_DYES, ConventionalItemTags.BROWN_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.GREEN_DYES, ConventionalItemTags.GREEN_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.RED_DYES, ConventionalItemTags.RED_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.WHITE_DYES, ConventionalItemTags.WHITE_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.YELLOW_DYES, ConventionalItemTags.YELLOW_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.LIGHT_BLUE_DYES, ConventionalItemTags.LIGHT_BLUE_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.LIGHT_GRAY_DYES, ConventionalItemTags.LIGHT_GRAY_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.LIME_DYES, ConventionalItemTags.LIME_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.MAGENTA_DYES, ConventionalItemTags.MAGENTA_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.ORANGE_DYES, ConventionalItemTags.ORANGE_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.PINK_DYES, ConventionalItemTags.PINK_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.CYAN_DYES, ConventionalItemTags.CYAN_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.GRAY_DYES, ConventionalItemTags.GRAY_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.PURPLE_DYES, ConventionalItemTags.PURPLE_DYES), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.RAW_IRON_ORES, ConventionalItemTags.IRON_RAW_MATERIALS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.RAW_GOLD_ORES, ConventionalItemTags.GOLD_RAW_MATERIALS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.DIAMONDS, ConventionalItemTags.DIAMOND_GEMS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.LAPIS, ConventionalItemTags.LAPIS_GEMS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.EMERALDS, ConventionalItemTags.EMERALD_GEMS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.QUARTZ, ConventionalItemTags.QUARTZ_GEMS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.SHEARS, ConventionalItemTags.SHEAR_TOOLS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.SPEARS, ConventionalItemTags.SPEAR_TOOLS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.BOWS, ConventionalItemTags.BOW_TOOLS), ConventionLogWarnings.createMapEntry(net.fabricmc.fabric.api.tag.convention.v1.ConventionalItemTags.SHIELDS, ConventionalItemTags.SHIELD_TOOLS), ConventionLogWarnings.createMapEntry(ConventionalEnchantmentTags.INCREASES_BLOCK_DROPS, net.fabricmc.fabric.api.tag.convention.v2.ConventionalEnchantmentTags.INCREASE_BLOCK_DROPS), ConventionLogWarnings.createMapEntry(ConventionalEnchantmentTags.INCREASES_ENTITY_DROPS, net.fabricmc.fabric.api.tag.convention.v2.ConventionalEnchantmentTags.INCREASE_ENTITY_DROPS), ConventionLogWarnings.createMapEntry(ConventionalEnchantmentTags.ENTITY_MOVEMENT_ENHANCEMENT, net.fabricmc.fabric.api.tag.convention.v2.ConventionalEnchantmentTags.ENTITY_SPEED_ENHANCEMENTS), ConventionLogWarnings.createMapEntry(ConventionalEnchantmentTags.ENTITY_DEFENSE_ENHANCEMENT, net.fabricmc.fabric.api.tag.convention.v2.ConventionalEnchantmentTags.ENTITY_DEFENSE_ENHANCEMENTS), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.IN_NETHER, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_NETHER), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.IN_THE_END, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_END), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.IN_OVERWORLD, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_OVERWORLD), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.CAVES, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_CAVE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.CLIMATE_COLD, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_COLD), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.CLIMATE_TEMPERATE, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_TEMPERATE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.CLIMATE_HOT, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_HOT), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.CLIMATE_WET, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_WET), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.CLIMATE_DRY, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_DRY), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.VEGETATION_DENSE, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_VEGETATION_DENSE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.VEGETATION_SPARSE, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_VEGETATION_SPARSE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.TREE_CONIFEROUS, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_CONIFEROUS_TREE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.TREE_DECIDUOUS, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_DECIDUOUS_TREE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.TREE_JUNGLE, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_JUNGLE_TREE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.TREE_SAVANNA, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_SAVANNA_TREE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.MOUNTAIN_PEAK, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_MOUNTAIN_PEAK), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.MOUNTAIN_SLOPE, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_MOUNTAIN_SLOPE), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.END_ISLANDS, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_OUTER_END_ISLAND), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.NETHER_FORESTS, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_NETHER_FOREST), ConventionLogWarnings.createMapEntry(ConventionalBiomeTags.FLOWER_FORESTS, net.fabricmc.fabric.api.tag.convention.v2.ConventionalBiomeTags.IS_FLOWER_FOREST), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "barrel", ConventionalBlockTags.BARRELS), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "chest", ConventionalBlockTags.CHESTS), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "wooden_chests", ConventionalBlockTags.WOODEN_CHESTS), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "glass", ConventionalBlockTags.GLASS_BLOCKS), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "glass_pane", ConventionalBlockTags.GLASS_PANES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "immobile", ConventionalBlockTags.RELOCATION_NOT_SUPPORTED), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "stone", ConventionalBlockTags.STONES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "cobblestone", ConventionalBlockTags.COBBLESTONES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "workbench", ConventionalBlockTags.VILLAGER_JOB_SITES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "workbenches", ConventionalBlockTags.VILLAGER_JOB_SITES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "workstation", ConventionalBlockTags.VILLAGER_JOB_SITES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "workstations", ConventionalBlockTags.VILLAGER_JOB_SITES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "crafting_table", ConventionalBlockTags.PLAYER_WORKSTATIONS_CRAFTING_TABLES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "crafting_tables", ConventionalBlockTags.PLAYER_WORKSTATIONS_CRAFTING_TABLES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "furnace", ConventionalBlockTags.PLAYER_WORKSTATIONS_FURNACES), ConventionLogWarnings.createMapEntry(class_7924.field_41254, "furnaces", ConventionalBlockTags.PLAYER_WORKSTATIONS_FURNACES), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "axes", class_3489.field_42612), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "pickaxes", class_3489.field_42614), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "hoes", class_3489.field_42613), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "shovels", class_3489.field_42615), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "swords", class_3489.field_42611), ConventionLogWarnings.createMapEntry(ConventionLogWarnings.createTagKeyUnderFabric(class_7924.field_41197, "axes"), class_3489.field_42612), ConventionLogWarnings.createMapEntry(ConventionLogWarnings.createTagKeyUnderFabric(class_7924.field_41197, "pickaxes"), class_3489.field_42614), ConventionLogWarnings.createMapEntry(ConventionLogWarnings.createTagKeyUnderFabric(class_7924.field_41197, "hoes"), class_3489.field_42613), ConventionLogWarnings.createMapEntry(ConventionLogWarnings.createTagKeyUnderFabric(class_7924.field_41197, "shovels"), class_3489.field_42615), ConventionLogWarnings.createMapEntry(ConventionLogWarnings.createTagKeyUnderFabric(class_7924.field_41197, "swords"), class_3489.field_42611), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "wrenches", ConventionalItemTags.WRENCH_TOOLS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "tools/wrenches", ConventionalItemTags.WRENCH_TOOLS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "barrel", ConventionalItemTags.BARRELS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "chest", ConventionalItemTags.CHESTS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "glass", ConventionalItemTags.GLASS_BLOCKS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "glass_pane", ConventionalItemTags.GLASS_PANES), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "glowstone_dusts", ConventionalItemTags.GLOWSTONE_DUSTS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "redstone_dusts", ConventionalItemTags.REDSTONE_DUSTS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "stone", ConventionalItemTags.STONES), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "string", ConventionalItemTags.STRINGS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "sticks", ConventionalItemTags.WOODEN_RODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "wooden_rods", ConventionalItemTags.WOODEN_RODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "food", ConventionalItemTags.FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "fruit", ConventionalItemTags.FRUIT_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "fruits", ConventionalItemTags.FRUIT_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "vegetable", ConventionalItemTags.VEGETABLE_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "vegetables", ConventionalItemTags.VEGETABLE_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "berry", ConventionalItemTags.BERRY_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "berries", ConventionalItemTags.BERRY_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "bread", ConventionalItemTags.BREAD_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "breads", ConventionalItemTags.BREAD_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "cookie", ConventionalItemTags.COOKIE_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "cookies", ConventionalItemTags.COOKIE_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "raw_meat", ConventionalItemTags.RAW_MEAT_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "raw_meats", ConventionalItemTags.RAW_MEAT_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "raw_fish", ConventionalItemTags.RAW_FISH_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "raw_fishes", ConventionalItemTags.RAW_FISH_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "cooked_meat", ConventionalItemTags.COOKED_MEAT_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "cooked_meats", ConventionalItemTags.COOKED_MEAT_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "cooked_fish", ConventionalItemTags.COOKED_FISH_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "cooked_fishes", ConventionalItemTags.COOKED_FISH_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "soup", ConventionalItemTags.SOUP_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "soups", ConventionalItemTags.SOUP_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "stew", ConventionalItemTags.SOUP_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "stews", ConventionalItemTags.SOUP_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "candy", ConventionalItemTags.CANDY_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "candies", ConventionalItemTags.CANDY_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "pie", ConventionalItemTags.PIE_FOODS), ConventionLogWarnings.createMapEntry(class_7924.field_41197, "pies", ConventionalItemTags.PIE_FOODS), ConventionLogWarnings.createMapEntry(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)"music_discs")), ConventionalItemTags.MUSIC_DISCS), ConventionLogWarnings.createMapEntry(class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"minecraft", (String)"tall_flowers")), ConventionalItemTags.TALL_FLOWERS), ConventionLogWarnings.createMapEntry(class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)class_2960.method_60655((String)"minecraft", (String)"tall_flowers")), ConventionalBlockTags.TALL_FLOWERS));

    private static LogWarningMode setupLogWarningModeProperty() {
        String property = System.getProperty("fabric-tag-conventions-v1.legacyTagWarning", LogWarningMode.SHORT.name()).toUpperCase(Locale.ROOT);
        try {
            return LogWarningMode.valueOf(property);
        }
        catch (Exception e) {
            LOGGER.error("Unknown entry `{}` for property `fabric-tag-conventions-v1.legacyTagWarning`.", (Object)property);
            return LogWarningMode.SILENCED;
        }
    }

    public void onInitialize() {
        if (FabricLoader.getInstance().isDevelopmentEnvironment() && LOG_LEGACY_WARNING_MODE != LogWarningMode.SILENCED) {
            ConventionLogWarnings.setupLegacyTagWarning();
        }
    }

    private static void setupLegacyTagWarning() {
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            ObjectArrayList legacyTags = new ObjectArrayList();
            class_5455.class_6890 dynamicRegistries = server.method_30611();
            dynamicRegistries.method_40311().forEach(arg_0 -> ConventionLogWarnings.lambda$setupLegacyTagWarning$1((List)legacyTags, arg_0));
            if (legacyTags.isEmpty()) {
                return;
            }
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("\n\tDev warning - Legacy Tags detected. Please migrate your old tags to our new format that follows better conventions!\n\tSee classes under net.fabricmc.fabric.api.tag.convention.v2 package for all tags.\n\n\tNOTE: Many tags have been moved around or renamed. Some new ones were added so please review the new tags.\n\tAnd make sure you follow tag conventions for new tags! The convention is `c` with nouns generally being plural and adjectives being singular.\n\tYou can disable this message by this system property to your runs: `-Dfabric-tag-conventions-v1.legacyTagWarning=SILENCED`.\n\tTo see individual legacy tags found, set the system property to `-Dfabric-tag-conventions-v1.legacyTagWarning=VERBOSE` instead. Default is `SHORT`.\n");
            if (LOG_LEGACY_WARNING_MODE.isVerbose()) {
                stringBuilder.append("\nLegacy tags and their replacement:");
                for (class_6862 tagKey : legacyTags) {
                    stringBuilder.append("\n     ").append(tagKey).append("  ->  ").append(LEGACY_C_TAGS.get(tagKey));
                }
            }
            LOGGER.warn(stringBuilder.toString());
            if (LOG_LEGACY_WARNING_MODE == LogWarningMode.FAIL) {
                throw new RuntimeException("Legacy Tag validation failed");
            }
        });
    }

    private static <T> AbstractMap.SimpleEntry<class_6862<T>, class_6862<T>> createMapEntry(class_6862<T> tag1, class_6862<T> tag2) {
        return new AbstractMap.SimpleEntry<class_6862<T>, class_6862<T>>(tag1, tag2);
    }

    private static <T> AbstractMap.SimpleEntry<class_6862<T>, class_6862<T>> createMapEntry(class_5321<class_2378<T>> registryKey, String tagId1, class_6862<T> tag2) {
        return new AbstractMap.SimpleEntry<class_6862<T>, class_6862<T>>(ConventionLogWarnings.createTagKeyUnderC(registryKey, tagId1), tag2);
    }

    private static <T> AbstractMap.SimpleEntry<class_6862<T>, class_6862<T>> createMapEntry(class_5321<class_2378<T>> registryKey, String tagId1, String tagId2) {
        return new AbstractMap.SimpleEntry<class_6862<T>, class_6862<T>>(ConventionLogWarnings.createTagKeyUnderC(registryKey, tagId1), ConventionLogWarnings.createTagKeyUnderC(registryKey, tagId2));
    }

    private static <T> class_6862<T> createTagKeyUnderC(class_5321<class_2378<T>> registryKey, String tagId) {
        return class_6862.method_40092(registryKey, (class_2960)class_2960.method_60655((String)"c", (String)tagId));
    }

    private static <T> class_6862<T> createTagKeyUnderFabric(class_5321<class_2378<T>> registryKey, String tagId) {
        return class_6862.method_40092(registryKey, (class_2960)class_2960.method_60655((String)"fabric", (String)tagId));
    }

    private static /* synthetic */ void lambda$setupLegacyTagWarning$1(List legacyTags, class_5455.class_6892 registryEntry) {
        if (registryEntry.comp_350().method_29177().method_12836().equals("minecraft")) {
            registryEntry.comp_351().method_40272().forEach(listEntry -> {
                class_6862 tagKey = class_6862.method_40092((class_5321)registryEntry.comp_350(), (class_2960)listEntry.method_40251().comp_327());
                if (LEGACY_C_TAGS.containsKey(tagKey)) {
                    legacyTags.add(tagKey);
                }
            });
        }
    }

    private static enum LogWarningMode {
        SILENCED,
        SHORT,
        VERBOSE,
        FAIL;


        boolean isVerbose() {
            return this == VERBOSE || this == FAIL;
        }
    }
}

