/*
 * Decompiled with CFR 0.152.
 */
package net.olafski.fastleafdecay.common;

import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import net.olafski.fastleafdecay.common.LeafHelper;

public final class LeafScheduler {
    private static long tickCounter = 0L;
    private static final Long2ObjectOpenHashMap<Map<class_5321<class_1937>, Set<class_2338>>> timeline = new Long2ObjectOpenHashMap();

    public static void enqueueIfCandidate(class_3218 level, class_2338 pos, int delay) {
        if (!level.method_8477(pos)) {
            return;
        }
        class_2680 s = level.method_8320(pos);
        if (!LeafHelper.isDecayCandidate(level, pos, s)) {
            return;
        }
        long eta = tickCounter + (long)Math.max(1, delay);
        Map perEta = (Map)timeline.computeIfAbsent(eta, k -> new HashMap());
        Set set = perEta.computeIfAbsent(level.method_27983(), k -> new HashSet());
        set.add(pos.method_10062());
    }

    public static void enqueueIfCandidate(class_3218 level, class_2338 pos, class_2680 stateHint, int delay) {
        if (!LeafHelper.isDecayCandidate(level, pos, stateHint)) {
            return;
        }
        LeafScheduler.enqueueIfCandidate(level, pos, delay);
    }

    public static void onServerTickPost(MinecraftServer server) {
        Map perEta;
        if ((perEta = (Map)timeline.remove(++tickCounter)) == null) {
            return;
        }
        for (Map.Entry entry : perEta.entrySet()) {
            class_3218 level = server.method_3847((class_5321)entry.getKey());
            if (level == null) continue;
            for (class_2338 pos : (Set)entry.getValue()) {
                LeafHelper.tryRandomTickLeaf(level, pos);
            }
        }
    }
}

