/*
 * Decompiled with CFR 0.152.
 */
package net.olafski.fastleafdecay.common;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.class_5819;

public class FldConfig {
    private static int minDelay = 4;
    private static int maxDelay = 7;

    public static void load(Path configDir) {
        Path file = configDir.resolve("fastleafdecay-common.properties");
        Properties p = new Properties();
        if (Files.exists(file, new LinkOption[0])) {
            try (BufferedReader r = Files.newBufferedReader(file);){
                p.load(r);
            }
            catch (IOException e) {
                System.err.println("[FLD] Failed to read config: " + e.getMessage());
            }
        }
        minDelay = FldConfig.parseInt(p, "minDelay", 4);
        maxDelay = FldConfig.parseInt(p, "maxDelay", 12);
        if (!Files.exists(file, new LinkOption[0])) {
            try (BufferedWriter w = Files.newBufferedWriter(file, new OpenOption[0]);){
                p.setProperty("minDelay", String.valueOf(minDelay));
                p.setProperty("maxDelay", String.valueOf(maxDelay));
                p.store(w, "FastLeafDecay basic config");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        System.out.println("[FLD] Config loaded: delay " + minDelay + "\u2013" + maxDelay + " ticks");
    }

    private static int parseInt(Properties p, String key, int def) {
        try {
            return Integer.parseInt(p.getProperty(key, String.valueOf(def)));
        }
        catch (NumberFormatException e) {
            return def;
        }
    }

    public static int getRandomDelay(class_5819 random) {
        if (minDelay >= maxDelay) {
            return minDelay;
        }
        return minDelay + random.method_43048(maxDelay - minDelay + 1);
    }
}

