/*
 * Decompiled with CFR 0.152.
 */
package xyz.nucleoid.packettweaker;

import com.mojang.authlib.GameProfile;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_2535;
import net.minecraft.class_2547;
import net.minecraft.class_2596;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7225;
import net.minecraft.class_8791;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import xyz.nucleoid.packettweaker.ContextProvidingPacketListener;
import xyz.nucleoid.packettweaker.impl.ConnectionClientAttachment;
import xyz.nucleoid.packettweaker.impl.EmptyContext;
import xyz.nucleoid.packettweaker.impl.LimitedContext;
import xyz.nucleoid.packettweaker.impl.MutableContext;
import xyz.nucleoid.packettweaker.impl.StaticPacketContext;
import xyz.nucleoid.packettweaker.impl.StaticPlayContext;

@ApiStatus.NonExtendable
public interface PacketContext {
    public static PacketContext get() {
        return MutableContext.get();
    }

    public static void runWithContext(@Nullable class_2535 connection, @Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Runnable runnable) {
        MutableContext.runWithContext(connection, networkHandler, packet, runnable);
    }

    public static void runWithContext(@Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Runnable runnable) {
        PacketContext.runWithContext(ContextProvidingPacketListener.getClientConnection(networkHandler), networkHandler, packet, runnable);
    }

    public static void runWithContext(@Nullable class_2547 networkHandler, Runnable runnable) {
        PacketContext.runWithContext(networkHandler, null, runnable);
    }

    public static <T> T supplyWithContext(@Nullable class_2535 connection, @Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Supplier<T> supplier) {
        return MutableContext.supplyWithContext(connection, networkHandler, packet, supplier);
    }

    public static <T> T supplyWithContext(@Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Supplier<T> supplier) {
        return PacketContext.supplyWithContext(ContextProvidingPacketListener.getClientConnection(networkHandler), networkHandler, packet, supplier);
    }

    public static <T> T supplyWithContext(@Nullable class_2547 networkHandler, Supplier<T> supplier) {
        return PacketContext.supplyWithContext(networkHandler, null, supplier);
    }

    public static <T> T supplyWithContext(@Nullable class_2535 connection, @Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Function<PacketContext, T> supplier) {
        return MutableContext.supplyWithContext(connection, networkHandler, packet, supplier);
    }

    public static <T> T supplyWithContext(@Nullable class_2547 networkHandler, @Nullable class_2596<?> packet, Function<PacketContext, T> supplier) {
        return PacketContext.supplyWithContext(ContextProvidingPacketListener.getClientConnection(networkHandler), networkHandler, packet, supplier);
    }

    public static <T> T supplyWithContext(@Nullable class_2547 networkHandler, Function<PacketContext, T> supplier) {
        return PacketContext.supplyWithContext(networkHandler, null, supplier);
    }

    public static NotNullWithPlayer create(class_3222 player) {
        return new StaticPlayContext(player.field_13987);
    }

    public static NotNullWithPlayer create(class_3244 listener) {
        return new StaticPlayContext(listener);
    }

    public static NotNull create(class_2547 listener) {
        return new StaticPacketContext(ContextProvidingPacketListener.of(listener).getClientConnectionForPacketTweaker());
    }

    public static NotNull create(class_2535 connection) {
        return new StaticPacketContext(connection);
    }

    public static PacketContext create(class_7225.class_7874 lookup) {
        return new LimitedContext(lookup, null, class_8791.method_53821());
    }

    public static PacketContext create() {
        return EmptyContext.INSTANCE;
    }

    @Nullable
    public static <T> T getData(class_2547 listener, Key<T> key) {
        return PacketContext.getData(((ContextProvidingPacketListener)listener).getClientConnectionForPacketTweaker(), key);
    }

    @Nullable
    public static <T> T setData(class_2547 listener, Key<T> key, @Nullable T data) {
        return PacketContext.setData(((ContextProvidingPacketListener)listener).getClientConnectionForPacketTweaker(), key, data);
    }

    @Nullable
    public static <T> T getData(class_2535 connection, Key<T> key) {
        if (connection == null) {
            return null;
        }
        return ((ConnectionClientAttachment)connection).packetTweaker$get(key);
    }

    @Nullable
    public static <T> T setData(class_2535 connection, Key<T> key, @Nullable T data) {
        if (connection == null) {
            return null;
        }
        return ((ConnectionClientAttachment)connection).packetTweaker$set(key, data);
    }

    @Nullable
    public class_3222 getPlayer();

    @Nullable
    public class_8791 getClientOptions();

    @Nullable
    public GameProfile getGameProfile();

    @Nullable
    public class_7225.class_7874 getRegistryWrapperLookup();

    public ContextProvidingPacketListener getPacketListener();

    @Nullable
    public class_2547 getBackingPacketListener();

    @Nullable
    public class_2535 getClientConnection();

    @Nullable
    default public <T> T getData(Key<T> key) {
        return PacketContext.getData(this.getClientConnection(), key);
    }

    @Nullable
    default public <T> T setData(Key<T> key, @Nullable T data) {
        return PacketContext.setData(this.getClientConnection(), key, data);
    }

    @Nullable
    public class_2596<?> getEncodedPacket();

    @Nullable
    public NotNull asNotNull();

    @Nullable
    public NotNullWithPlayer asNotNullWithPlayer();

    public PacketContext copy();

    @Deprecated
    public static PacketContext of(class_3222 player) {
        return PacketContext.create(player.field_13987);
    }

    @Deprecated
    public static PacketContext of(class_2547 listener) {
        return PacketContext.create(listener);
    }

    @Deprecated
    public static PacketContext of(class_2535 connection) {
        return PacketContext.create(connection);
    }

    @Deprecated
    public static PacketContext of() {
        return PacketContext.create();
    }

    @Deprecated
    @Nullable
    default public class_3222 getTarget() {
        return this.getPlayer();
    }

    public static final class Key<T> {
        private final String id;

        private Key(String id) {
            this.id = id;
        }

        public static <T> Key<T> of(String id) {
            return new Key<T>(id);
        }

        public String toString() {
            return "Key[" + this.id + "]";
        }
    }

    @ApiStatus.NonExtendable
    public static interface NotNullWithPlayer
    extends NotNull {
        @Override
        public class_3222 getPlayer();

        @Override
        public class_8791 getClientOptions();

        @Override
        public GameProfile getGameProfile();

        @Override
        public NotNullWithPlayer copy();
    }

    @ApiStatus.NonExtendable
    public static interface NotNull
    extends PacketContext {
        @Override
        public class_7225.class_7874 getRegistryWrapperLookup();

        @Override
        public ContextProvidingPacketListener getPacketListener();

        @Override
        public class_2547 getBackingPacketListener();

        @Override
        public class_2535 getClientConnection();

        @Override
        public NotNull copy();
    }
}

