/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.protocol;

import com.mojang.logging.LogUtils;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import org.enginehub.worldeditcui.protocol.CUIPacketHandler;
import org.slf4j.Logger;

class CUIPacketHandlers0 {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final ServiceLoader<CUIPacketHandler> HANDLER_DISCOVERY = ServiceLoader.load(CUIPacketHandler.class);
    public static final CUIPacketHandler HANDLER_IMPL;

    CUIPacketHandlers0() {
    }

    static {
        HashSet knownProviders = new HashSet();
        try {
            List<CUIPacketHandler> handlers = HANDLER_DISCOVERY.stream().peek(prov -> knownProviders.add(prov.type().getCanonicalName())).map(ServiceLoader.Provider::get).toList();
            if (handlers.isEmpty()) {
                throw new IllegalStateException("No CUI protocol providers available");
            }
            HANDLER_IMPL = handlers.getFirst();
        }
        catch (ServiceConfigurationError ex) {
            LOGGER.error("Failed to discover a CUI protocol handler, from known providers {}:", knownProviders, (Object)ex);
            throw new IllegalStateException("Failed to configure CUI protocol handlers", ex);
        }
    }
}

