/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.protocol;

import com.mojang.logging.LogUtils;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;

public record CUIPacket(boolean multi, String eventType, List<String> args) implements class_8710
{
    private static final String PROTOCOL_VERSION = "4";
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final class_8710.class_9154<CUIPacket> TYPE = new class_8710.class_9154(class_2960.method_60655((String)"worldedit", (String)"cui"));
    public static final class_9139<class_9129, CUIPacket> CODEC = class_8710.method_56484(CUIPacket::encode, CUIPacket::decode);

    public CUIPacket {
        args = List.copyOf(args);
    }

    public CUIPacket(String eventType, String ... args) {
        this(false, eventType, List.of(args));
    }

    public static String protocolVersion() {
        return PROTOCOL_VERSION;
    }

    private static CUIPacket decode(class_2540 buf) {
        int readableBytes = buf.readableBytes();
        if (readableBytes <= 0) {
            throw new IllegalStateException("Warning, invalid (zero length) payload received");
        }
        String payload = buf.toString(StandardCharsets.UTF_8);
        buf.method_52988(buf.readerIndex() + buf.readableBytes());
        String[] split = payload.split("\\|", -1);
        boolean multi = split[0].startsWith("+");
        String type = split[0].substring(multi ? 1 : 0);
        List<String> args = split.length > 1 ? List.of(Arrays.copyOfRange(split, 1, split.length)) : List.of();
        CUIPacket pkt = new CUIPacket(multi, type, args);
        LOGGER.debug("Received CUI event from server: {}", (Object)pkt);
        return pkt;
    }

    private void encode(class_2540 buf) {
        StringBuilder builder = new StringBuilder();
        if (this.multi()) {
            builder.append('+');
        }
        builder.append(this.eventType());
        for (String arg : this.args()) {
            builder.append('|');
            builder.append(arg);
        }
        buf.method_52983(builder.toString().getBytes(StandardCharsets.UTF_8));
    }

    @NotNull
    public class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }
}

