/*
 * Decompiled with CFR 0.152.
 */
package org.enginehub.worldeditcui.fabric.network;

import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import org.enginehub.worldeditcui.protocol.CUIPacket;
import org.enginehub.worldeditcui.protocol.CUIPacketHandler;

public class FabricCUIPacketHandler
implements CUIPacketHandler {
    private static final Set<BiConsumer<CUIPacket, CUIPacketHandler.PacketContext>> CLIENTBOUND_HANDLERS = ConcurrentHashMap.newKeySet();
    private static final Set<BiConsumer<CUIPacket, CUIPacketHandler.PacketContext>> SERVERBOUND_HANDLERS = ConcurrentHashMap.newKeySet();

    static void register() {
        ServerPlayNetworking.registerGlobalReceiver(CUIPacket.TYPE, (pkt, ctx) -> {
            CUIPacketHandler.PacketContext cuiCtx = new CUIPacketHandler.PacketContext((class_1657)ctx.player(), (Executor)ctx.player().method_5682());
            for (BiConsumer<CUIPacket, CUIPacketHandler.PacketContext> handler : SERVERBOUND_HANDLERS) {
                handler.accept((CUIPacket)pkt, cuiCtx);
            }
        });
    }

    static void registerClient() {
        ClientPlayNetworking.registerGlobalReceiver(CUIPacket.TYPE, ClientHandler::clientHandler);
    }

    @Override
    public void registerClientboundHandler(BiConsumer<CUIPacket, CUIPacketHandler.PacketContext> clientbound) {
        CLIENTBOUND_HANDLERS.add(Objects.requireNonNull(clientbound, "clientbound"));
    }

    @Override
    public void registerServerboundHandler(BiConsumer<CUIPacket, CUIPacketHandler.PacketContext> serverbound) {
        SERVERBOUND_HANDLERS.add(Objects.requireNonNull(serverbound, "serverbound"));
    }

    private static class ClientHandler {
        private ClientHandler() {
        }

        private static void clientHandler(CUIPacket pkt, ClientPlayNetworking.Context ctx) {
            CUIPacketHandler.PacketContext cuiCtx = new CUIPacketHandler.PacketContext((class_1657)ctx.player(), (Executor)ctx.client());
            for (BiConsumer<CUIPacket, CUIPacketHandler.PacketContext> handler : CLIENTBOUND_HANDLERS) {
                handler.accept(pkt, cuiCtx);
            }
        }
    }
}

