/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.hoetweaks_common_neoforge.events;

import com.natamus.collective_common_neoforge.functions.CompareBlockFunctions;
import com.natamus.collective_common_neoforge.services.Services;
import com.natamus.hoetweaks_common_neoforge.config.ConfigHandler;
import com.natamus.hoetweaks_common_neoforge.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class HoeEvent {
    public static boolean onHoeRightClickBlock(Level level, Player player, InteractionHand hand, BlockPos cpos, BlockHitResult hitVec) {
        int damage;
        if (level.isClientSide) {
            return true;
        }
        ItemStack stack = player.getItemInHand(hand);
        if (!Services.TOOLFUNCTIONS.isHoe(stack)) {
            return true;
        }
        if (ConfigHandler.onlyUntillWithOtherHandEmpty && !player.getMainHandItem().isEmpty() && !player.getOffhandItem().isEmpty()) {
            return true;
        }
        Block block = level.getBlockState(cpos).getBlock();
        if (block.equals(Blocks.AIR)) {
            cpos = cpos.below().immutable();
            block = level.getBlockState(cpos).getBlock();
        }
        if (block.equals(Blocks.FARMLAND)) {
            if (!player.isCrouching() && ConfigHandler.mustCrouchToHaveBiggerHoeRange) {
                level.setBlock(cpos, Blocks.DIRT.defaultBlockState(), 3);
                damage = 1;
            } else {
                int range = Util.getHoeRange(level, stack);
                damage = Util.processSoilGetDamage(level, cpos, range, Blocks.DIRT, true);
            }
            Vec3 pvec = player.position();
            if (pvec.y % 1.0 != 0.0) {
                player.setPos(pvec.x, Math.ceil(pvec.y), pvec.z);
            }
        } else if (CompareBlockFunctions.isDirtBlock((Block)block)) {
            if (!player.isCrouching() && ConfigHandler.mustCrouchToHaveBiggerHoeRange) {
                return true;
            }
            int range = Util.getHoeRange(level, stack);
            damage = Util.processSoilGetDamage(level, cpos, range, Blocks.FARMLAND, false);
        } else {
            return true;
        }
        level.playSound(null, (double)cpos.getX(), (double)cpos.getY(), (double)cpos.getZ(), SoundEvents.HOE_TILL, SoundSource.BLOCKS, 0.5f, 1.0f);
        player.swing(hand);
        if (!player.isCreative()) {
            stack.hurtAndBreak(damage, (ServerLevel)level, (ServerPlayer)player, item -> {});
        }
        return false;
    }

    public static float onHarvestBreakSpeed(Level world, Player player, float digSpeed, BlockState state) {
        ItemStack handstack = player.getMainHandItem();
        if (!Services.TOOLFUNCTIONS.isHoe(handstack)) {
            return digSpeed;
        }
        Block block = state.getBlock();
        if (block instanceof PumpkinBlock || block.equals(Blocks.MELON)) {
            return (float)ConfigHandler.cropBlockBreakSpeedModifier;
        }
        return digSpeed;
    }
}

