/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.pocket.core;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.api.pocket.IPocketAccess;
import dan200.computercraft.api.pocket.IPocketUpgrade;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.core.computer.ComputerSide;
import dan200.computercraft.core.util.Nullability;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.computer.core.ServerComputer;
import dan200.computercraft.shared.network.client.PocketComputerDataMessage;
import dan200.computercraft.shared.network.server.ServerNetworking;
import dan200.computercraft.shared.pocket.core.PocketComputerInternal;
import dan200.computercraft.shared.pocket.core.PocketHolder;
import dan200.computercraft.shared.pocket.core.PocketServerComputer;
import dan200.computercraft.shared.pocket.core.PocketSide;
import dan200.computercraft.shared.util.DataComponentUtil;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_9282;
import net.minecraft.class_9326;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9848;
import org.jspecify.annotations.Nullable;

public final class PocketBrain
implements PocketComputerInternal {
    private final PocketServerComputer computer;
    private PocketHolder holder;
    private class_243 position;
    private final Map<PocketSide, UpgradeAccess> upgrades = new EnumMap<PocketSide, UpgradeAccess>(PocketSide.class);

    public PocketBrain(PocketHolder holder, ServerComputer.Properties properties) {
        this.computer = new PocketServerComputer(this, holder, properties);
        this.holder = holder;
        this.position = holder.pos();
        this.upgrades.put(PocketSide.BACK, new UpgradeAccess((class_9331<UpgradeData<IPocketUpgrade>>)((class_9331)ModRegistry.DataComponents.BACK_POCKET_UPGRADE.get()), ComputerSide.BACK));
        this.upgrades.put(PocketSide.BOTTOM, new UpgradeAccess((class_9331<UpgradeData<IPocketUpgrade>>)((class_9331)ModRegistry.DataComponents.BOTTOM_POCKET_UPGRADE.get()), ComputerSide.BOTTOM));
    }

    public PocketServerComputer computer() {
        return this.computer;
    }

    PocketHolder holder() {
        return this.holder;
    }

    public void updateHolder(PocketHolder newHolder) {
        PocketHolder.PlayerHolder player;
        class_3222 oldPlayer;
        this.position = newHolder.pos();
        this.computer.setPosition(newHolder.level(), newHolder.blockPos());
        PocketHolder oldHolder = this.holder;
        if (this.holder.equals(newHolder)) {
            return;
        }
        this.holder = newHolder;
        if (oldHolder instanceof PocketHolder.PlayerHolder) {
            PocketHolder.PlayerHolder p = (PocketHolder.PlayerHolder)oldHolder;
            v0 = p.entity();
        } else {
            v0 = oldPlayer = null;
        }
        if (newHolder instanceof PocketHolder.PlayerHolder && (player = (PocketHolder.PlayerHolder)newHolder).entity() != oldPlayer) {
            ServerNetworking.sendToPlayer(new PocketComputerDataMessage(this.computer, true), player.entity());
        }
    }

    @Override
    public class_3218 getLevel() {
        return this.computer.getLevel();
    }

    @Override
    public class_243 getPosition() {
        return this.position;
    }

    private void requireMainThread() {
        if (!this.computer.getLevel().method_8503().method_18854()) {
            throw new IllegalStateException("Must be called from the main thread");
        }
    }

    private class_1799 requireStack() {
        this.requireMainThread();
        class_1799 stack = this.holder.getStack(this.computer);
        if (stack.method_7960()) {
            throw new IllegalStateException("Pocket computer is not active");
        }
        return stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public @Nullable class_1297 getEntity() {
        this.requireMainThread();
        PocketHolder pocketHolder = this.holder;
        if (!(pocketHolder instanceof PocketHolder.EntityHolder)) return null;
        PocketHolder.EntityHolder entity = (PocketHolder.EntityHolder)pocketHolder;
        if (!this.holder.isValid(this.computer)) return null;
        class_1297 class_12972 = entity.entity();
        return class_12972;
    }

    @Override
    public boolean isActive() {
        this.requireMainThread();
        return this.holder.isValid(this.computer);
    }

    @Override
    public int getColour() {
        return class_9282.method_57470((class_1799)this.requireStack(), (int)-1);
    }

    @Override
    public void setColour(int colour) {
        class_1799 stack = this.requireStack();
        if (class_9282.method_57470((class_1799)stack, (int)-1) == colour) {
            return;
        }
        if (colour == -1) {
            stack.method_57381(class_9334.field_49644);
        } else {
            DataComponentUtil.setDyeColour(stack, colour);
        }
        this.holder.setChanged();
    }

    public int getLight() {
        int count = 0;
        int totalR = 0;
        int totalG = 0;
        int totalB = 0;
        for (UpgradeAccess upgrade : this.upgrades.values()) {
            int colour = upgrade.lightColour;
            if (colour == -1) continue;
            ++count;
            totalR += class_9848.method_61327((int)colour);
            totalG += class_9848.method_61329((int)colour);
            totalB += class_9848.method_61331((int)colour);
        }
        return count == 0 ? -1 : class_9848.method_61323((int)(totalR / count), (int)(totalG / count), (int)(totalB / count));
    }

    public void tick() {
        for (UpgradeAccess holder : this.upgrades.values()) {
            if (holder.upgrade == null) continue;
            holder.upgrade.upgrade().update(holder, this.computer.getPeripheral(holder.side));
        }
    }

    public boolean onRightClick(class_3218 level) {
        for (UpgradeAccess holder : this.upgrades.values()) {
            if (holder.upgrade == null) continue;
            return holder.upgrade.upgrade().onRightClick(level, holder, this.computer.getPeripheral(holder.side));
        }
        return false;
    }

    private UpgradeAccess getUpgradeAccess(PocketSide side) {
        return Nullability.assertNonNull(this.upgrades.get((Object)side));
    }

    @Override
    public @Nullable UpgradeData<IPocketUpgrade> getUpgrade(PocketSide side) {
        return this.getUpgradeAccess(side).getUpgrade();
    }

    @Override
    public void setUpgrade(PocketSide side, @Nullable UpgradeData<IPocketUpgrade> upgrade) {
        this.getUpgradeAccess(side).setUpgrade(upgrade);
    }

    public void setUpgrades(@Nullable UpgradeData<IPocketUpgrade> back, @Nullable UpgradeData<IPocketUpgrade> bottom) {
        this.getUpgradeAccess(PocketSide.BACK).setUpgradeDirect(back);
        this.getUpgradeAccess(PocketSide.BOTTOM).setUpgradeDirect(bottom);
    }

    private final class UpgradeAccess
    implements IPocketAccess {
        private final class_9331<UpgradeData<IPocketUpgrade>> component;
        private final ComputerSide side;
        private @Nullable UpgradeData<IPocketUpgrade> upgrade;
        private int lightColour = -1;

        private UpgradeAccess(class_9331<UpgradeData<IPocketUpgrade>> component, ComputerSide side) {
            this.component = component;
            this.side = side;
        }

        @Override
        public class_3218 getLevel() {
            return PocketBrain.this.getLevel();
        }

        @Override
        public class_243 getPosition() {
            return PocketBrain.this.getPosition();
        }

        @Override
        public @Nullable class_1297 getEntity() {
            return PocketBrain.this.getEntity();
        }

        @Override
        public boolean isActive() {
            return PocketBrain.this.isActive();
        }

        @Override
        public int getColour() {
            return PocketBrain.this.getColour();
        }

        @Override
        public void setColour(int colour) {
            PocketBrain.this.setColour(colour);
        }

        @Override
        public int getLight() {
            return this.lightColour;
        }

        @Override
        public void setLight(int colour) {
            if (colour < 0 || colour > 0xFFFFFF) {
                colour = -1;
            }
            this.lightColour = colour;
        }

        @Override
        public class_9326 getUpgradeData() {
            UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
            return upgrade == null ? class_9326.field_49588 : upgrade.data();
        }

        @Override
        public void setUpgradeData(class_9326 data) {
            class_1799 stack = PocketBrain.this.requireStack();
            UpgradeData<IPocketUpgrade> upgrade = this.upgrade;
            if (upgrade == null || upgrade.data().equals((Object)data)) {
                return;
            }
            this.upgrade = UpgradeData.of(upgrade.holder(), data);
            stack.method_57379(this.component, upgrade);
            PocketBrain.this.holder.setChanged();
        }

        @Override
        public void invalidatePeripheral() {
            IPeripheral peripheral = this.upgrade == null ? null : this.upgrade.upgrade().createPeripheral(this);
            PocketBrain.this.computer.setPeripheral(this.side, peripheral);
        }

        @Override
        public @Nullable UpgradeData<IPocketUpgrade> getUpgrade() {
            return this.upgrade;
        }

        @Override
        public void setUpgrade(@Nullable UpgradeData<IPocketUpgrade> upgrade) {
            class_1799 stack = PocketBrain.this.requireStack();
            if (!this.setUpgradeDirect(upgrade)) {
                return;
            }
            stack.method_57379(this.component, upgrade);
            PocketBrain.this.holder.setChanged();
        }

        private boolean setUpgradeDirect(@Nullable UpgradeData<IPocketUpgrade> upgrade) {
            if (Objects.equals(this.upgrade, upgrade)) {
                return false;
            }
            this.upgrade = upgrade;
            this.lightColour = -1;
            this.invalidatePeripheral();
            return true;
        }
    }
}

