/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.media;

import dan200.computercraft.api.ComputerCraftAPI;
import dan200.computercraft.api.filesystem.Mount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.config.ConfigSpec;
import dan200.computercraft.shared.util.DataComponentUtil;
import dan200.computercraft.shared.util.NonNegativeId;
import dan200.computercraft.shared.util.StorageCapacity;
import java.util.function.IntFunction;
import java.util.function.Supplier;
import net.minecraft.class_1799;
import net.minecraft.class_3218;
import net.minecraft.class_7225;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import org.jspecify.annotations.Nullable;

public final class MountMedia<T extends NonNegativeId>
implements IMedia {
    public static final IMedia COMPUTER = new MountMedia("computer", ModRegistry.DataComponents.COMPUTER_ID, null, ConfigSpec.computerSpaceLimit);
    public static final IMedia DISK = new MountMedia<NonNegativeId.Disk>("disk", ModRegistry.DataComponents.DISK_ID, NonNegativeId.Disk::new, ConfigSpec.floppySpaceLimit);
    private final String subPath;
    private final Supplier<class_9331<T>> id;
    private final @Nullable IntFunction<T> createId;
    private final Supplier<Integer> defaultCapacity;

    public MountMedia(String subPath, Supplier<class_9331<T>> id, @Nullable IntFunction<T> createId, Supplier<Integer> defaultCapacity) {
        this.subPath = subPath;
        this.id = id;
        this.createId = createId;
        this.defaultCapacity = defaultCapacity;
    }

    @Override
    public @Nullable String getLabel(class_7225.class_7874 registries, class_1799 stack) {
        return DataComponentUtil.getCustomName((class_9322)stack);
    }

    @Override
    public boolean setLabel(class_1799 stack, @Nullable String label) {
        DataComponentUtil.setCustomName(stack, label);
        return true;
    }

    @Override
    public @Nullable Mount createDataMount(class_1799 stack, class_3218 level) {
        int id;
        int n = id = this.createId != null ? NonNegativeId.getOrCreate(level.method_8503(), stack, this.id.get(), this.createId, this.subPath) : NonNegativeId.getId((NonNegativeId)stack.method_58694(this.id.get()));
        if (id < 0) {
            return null;
        }
        long capacity = StorageCapacity.getOrDefault((StorageCapacity)stack.method_58694((class_9331)ModRegistry.DataComponents.STORAGE_CAPACITY.get()), this.defaultCapacity);
        return ComputerCraftAPI.createSaveDirMount(level.method_8503(), this.subPath + "/" + id, capacity);
    }
}

