/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.impl;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dan200.computercraft.api.upgrades.UpgradeBase;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.api.upgrades.UpgradeType;
import dan200.computercraft.shared.util.SafeDispatchCodec;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9326;
import org.jspecify.annotations.Nullable;

public final class UpgradeManager<T extends UpgradeBase> {
    private final class_5321<class_2378<T>> registry;
    private final Codec<T> upgradeCodec;
    private final Codec<UpgradeData<T>> dataCodec;
    private final class_9139<class_9129, UpgradeData<T>> dataStreamCodec;

    UpgradeManager(class_5321<class_2378<UpgradeType<? extends T>>> typeRegistry, class_5321<class_2378<T>> registry, Function<T, UpgradeType<? extends T>> getType) {
        this.registry = registry;
        this.upgradeCodec = SafeDispatchCodec.ofRegistry(typeRegistry, getType, UpgradeType::codec);
        Codec holderCodec = class_6899.method_40400(registry).xmap(x -> (class_6880.class_6883)x, x -> x);
        Codec fullCodec = RecordCodecBuilder.create(i -> i.group((App)holderCodec.fieldOf("id").forGetter(UpgradeData::holder), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(UpgradeData::data)).apply((Applicative)i, UpgradeData::new));
        this.dataCodec = Codec.withAlternative((Codec)fullCodec, (Codec)holderCodec, UpgradeData::ofDefault);
        this.dataStreamCodec = class_9139.method_56435((class_9139)class_9135.method_56383(registry).method_56432(x -> (class_6880.class_6883)x, x -> x), UpgradeData::holder, (class_9139)class_9326.field_49590, UpgradeData::data, UpgradeData::new);
    }

    public Codec<T> upgradeCodec() {
        return this.upgradeCodec;
    }

    public Codec<UpgradeData<T>> upgradeDataCodec() {
        return this.dataCodec;
    }

    public class_9139<class_9129, UpgradeData<T>> upgradeDataStreamCodec() {
        return this.dataStreamCodec;
    }

    public String getOwner(class_6880.class_6883<T> upgrade) {
        String ns = upgrade.method_40237().method_29177().method_12836();
        return ns.equals("minecraft") ? "computercraft" : ns;
    }

    public String getOwner(@Nullable UpgradeData<T> first, @Nullable UpgradeData<T> second) {
        String mod;
        if (first != null && !(mod = this.getOwner(first.holder())).equals("computercraft")) {
            return mod;
        }
        if (second != null && !(mod = this.getOwner(second.holder())).equals("computercraft")) {
            return mod;
        }
        return "computercraft";
    }

    public @Nullable UpgradeData<T> get(class_7225.class_7874 registries, class_1799 stack) {
        if (stack.method_7960()) {
            return null;
        }
        return registries.method_46762(this.registry).method_42017().filter(holder -> {
            UpgradeBase upgrade = (UpgradeBase)holder.comp_349();
            class_1799 craftingStack = upgrade.getCraftingItem();
            return !craftingStack.method_7960() && craftingStack.method_7909() == stack.method_7909() && upgrade.isItemSuitable(stack);
        }).findAny().map(x -> UpgradeData.of(x, ((UpgradeBase)x.comp_349()).getUpgradeData(stack))).orElse(null);
    }

    public static class_2561 getName(String baseString, @Nullable UpgradeBase first, @Nullable UpgradeBase second) {
        if (first != null && second != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded_twice"), (Object[])new Object[]{second.getAdjective(), first.getAdjective()});
        }
        if (first != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded"), (Object[])new Object[]{first.getAdjective()});
        }
        if (second != null) {
            return class_2561.method_43469((String)(baseString + ".upgraded"), (Object[])new Object[]{second.getAdjective()});
        }
        return class_2561.method_43471((String)baseString);
    }
}

