/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.render.monitor;

import com.mojang.blaze3d.buffers.GpuBuffer;
import com.mojang.blaze3d.buffers.GpuBufferSlice;
import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.systems.CommandEncoder;
import com.mojang.blaze3d.systems.RenderPass;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.textures.GpuTextureView;
import com.mojang.blaze3d.vertex.VertexFormat;
import dan200.computercraft.client.FrameInfo;
import dan200.computercraft.client.integration.ShaderMod;
import dan200.computercraft.client.render.monitor.MonitorRenderState;
import dan200.computercraft.client.render.text.DirectFixedWidthFontRenderer;
import dan200.computercraft.client.render.text.FixedWidthFontRenderer;
import dan200.computercraft.core.terminal.Terminal;
import dan200.computercraft.shared.config.Config;
import dan200.computercraft.shared.peripheral.monitor.ClientMonitor;
import dan200.computercraft.shared.peripheral.monitor.MonitorBlockEntity;
import dan200.computercraft.shared.util.DirectionUtil;
import java.nio.ByteBuffer;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_758;
import net.minecraft.class_7833;
import net.minecraft.class_827;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import org.joml.Vector4fc;
import org.jspecify.annotations.Nullable;
import org.lwjgl.system.MemoryUtil;

@Environment(value=EnvType.CLIENT)
public class MonitorBlockEntityRenderer
implements class_827<MonitorBlockEntity> {
    private static final float MARGIN = 0.034375f;
    private static @Nullable ByteBuffer backingBuffer;

    public MonitorBlockEntityRenderer(class_5614.class_5615 context) {
    }

    public void render(MonitorBlockEntity monitor, float partialTicks, class_4587 transform, class_4597 bufferSource, int lightmapCoord, int overlayLight, class_243 camera) {
        ClientMonitor originTerminal = monitor.getOriginClientMonitor();
        if (originTerminal == null) {
            return;
        }
        MonitorBlockEntity origin = originTerminal.getOrigin();
        MonitorRenderState renderState = originTerminal.getRenderState(MonitorRenderState::new);
        class_2338 monitorPos = monitor.method_11016();
        long renderFrame = FrameInfo.getRenderFrame();
        if (renderState.lastRenderFrame == renderFrame && !monitorPos.equals((Object)renderState.lastRenderPos)) {
            return;
        }
        renderState.lastRenderFrame = renderFrame;
        renderState.lastRenderPos = monitorPos;
        class_2338 originPos = origin.method_11016();
        class_2350 dir = origin.getDirection();
        class_2350 front = origin.getFront();
        float yaw = dir.method_10144();
        float pitch = DirectionUtil.toPitchAngle(front);
        transform.method_22903();
        transform.method_22904((double)(originPos.method_10263() - monitorPos.method_10263()) + 0.5, (double)(originPos.method_10264() - monitorPos.method_10264()) + 0.5, (double)(originPos.method_10260() - monitorPos.method_10260()) + 0.5);
        transform.method_22907((Quaternionfc)class_7833.field_40715.rotationDegrees(yaw));
        transform.method_22907((Quaternionfc)class_7833.field_40714.rotationDegrees(pitch));
        transform.method_22904(-0.34375, (double)origin.getHeight() - 0.5 - 0.15625 + 0.0, 0.5);
        double xSize = (double)origin.getWidth() - 0.3125;
        double ySize = (double)origin.getHeight() - 0.3125;
        Terminal terminal = originTerminal.getTerminal();
        if (terminal != null && !ShaderMod.get().isRenderingShadowPass()) {
            int width = terminal.getWidth();
            int height = terminal.getHeight();
            int pixelWidth = width * 6;
            int pixelHeight = height * 9;
            double xScale = xSize / (double)pixelWidth;
            double yScale = ySize / (double)pixelHeight;
            transform.method_22903();
            transform.method_22905((float)xScale, (float)(-yScale), 1.0f);
            Matrix4f matrix = transform.method_23760().method_23761();
            MonitorBlockEntityRenderer.renderTerminal(matrix, originTerminal, renderState, terminal, (float)((double)0.034375f / xScale), (float)((double)0.034375f / yScale));
            transform.method_22909();
        } else {
            FixedWidthFontRenderer.drawEmptyTerminal(FixedWidthFontRenderer.toVertexConsumer(transform, bufferSource.getBuffer(FixedWidthFontRenderer.TERMINAL_TEXT)), -0.034375f, 0.034375f, (float)(xSize + (double)0.06875f), (float)(-(ySize + (double)0.06875f)));
        }
        transform.method_22909();
    }

    private static void renderTerminal(Matrix4f matrix, ClientMonitor monitor, MonitorRenderState renderState, Terminal terminal, float xMargin, float yMargin) {
        boolean redraw = monitor.pollTerminalChanged();
        if (renderState.vertexBuffer == null) {
            redraw = true;
        }
        if (redraw) {
            int maxQuadCount = 1 + terminal.getWidth() * terminal.getHeight() + (terminal.getWidth() + 2) * (terminal.getHeight() + 2);
            int maxVertexCount = 4 * maxQuadCount;
            DirectFixedWidthFontRenderer.QuadEmitter sink = ShaderMod.get().getQuadEmitter(maxQuadCount, MonitorBlockEntityRenderer::getBuffer);
            DirectFixedWidthFontRenderer.drawTerminalBackground(sink, 0.0f, 0.0f, terminal, yMargin, yMargin, xMargin, xMargin);
            int vertexCountAfterBackground = sink.vertexCount();
            DirectFixedWidthFontRenderer.drawTerminalForeground(sink, 0.0f, 0.0f, terminal);
            int vertexCountAfterForeground = sink.vertexCount();
            DirectFixedWidthFontRenderer.drawCursor(sink, 0.0f, 0.0f, terminal);
            int vertexCountAfterCursor = sink.vertexCount();
            if (vertexCountAfterCursor > maxVertexCount) {
                throw new IllegalStateException("Drew too many vertices. Expected " + maxVertexCount + ", drew " + vertexCountAfterCursor);
            }
            if (vertexCountAfterCursor != 0) {
                renderState.register();
                CommandEncoder commandEncoder = RenderSystem.getDevice().createCommandEncoder();
                ByteBuffer resultBuffer = sink.byteBuffer().flip();
                if (resultBuffer.remaining() != sink.format().getVertexSize() * vertexCountAfterCursor) {
                    throw new IllegalStateException(String.format("Mismatched vertex count. Buffer is %d bytes long, but was expected to be %d (vertex size) * %d (vertex count) = %d bytes.", resultBuffer.limit(), sink.format().getVertexSize(), vertexCountAfterCursor, sink.format().getVertexSize() * vertexCountAfterCursor));
                }
                if (renderState.vertexBuffer == null || resultBuffer.remaining() > renderState.vertexBuffer.size()) {
                    if (renderState.vertexBuffer != null) {
                        renderState.vertexBuffer.close();
                        renderState.vertexBuffer = null;
                    }
                    renderState.vertexBuffer = RenderSystem.getDevice().createBuffer(() -> "Monitor at " + String.valueOf(monitor.getOrigin().method_11016()), 40, resultBuffer);
                } else if (!renderState.vertexBuffer.isClosed()) {
                    commandEncoder.writeToBuffer(renderState.vertexBuffer.slice(), resultBuffer);
                }
            }
            renderState.vertexCountAfterBackground = vertexCountAfterBackground;
            renderState.vertexCountAfterForeground = vertexCountAfterForeground;
            renderState.vertexCountAfterCursor = vertexCountAfterCursor;
        }
        if (renderState.vertexCountAfterCursor == 0) {
            return;
        }
        GpuBufferSlice oldFog = RenderSystem.getShaderFog();
        RenderSystem.setShaderFog((GpuBufferSlice)class_310.method_1551().field_1773.field_60793.method_71109(class_758.class_4596.field_60101));
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().mul((Matrix4fc)matrix);
        MonitorBlockEntityRenderer.drawWithShader(renderState, FixedWidthFontRenderer.TERMINAL_TEXT, class_10799.field_56818, 0, renderState.vertexCountAfterBackground);
        MonitorBlockEntityRenderer.drawWithShader(renderState, FixedWidthFontRenderer.TERMINAL_TEXT_OFFSET, class_10799.field_56821, renderState.vertexCountAfterBackground, (FixedWidthFontRenderer.isCursorVisible(terminal) && FrameInfo.getGlobalCursorBlink() ? renderState.vertexCountAfterCursor : renderState.vertexCountAfterForeground) - renderState.vertexCountAfterBackground);
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.setShaderFog((GpuBufferSlice)oldFog);
    }

    private static void drawWithShader(MonitorRenderState renderState, class_1921 renderType, RenderPipeline pipeline, int vertexOffset, int vertexCount) {
        GpuTextureView colourTarget;
        if (renderState.vertexBuffer == null) {
            throw new IllegalStateException("MonitorRenderState has not been initialised");
        }
        if (vertexCount == 0) {
            return;
        }
        GpuBufferSlice transforms = RenderSystem.getDynamicUniforms().method_71106((Matrix4fc)RenderSystem.getModelViewMatrix(), (Vector4fc)new Vector4f(1.0f, 1.0f, 1.0f, 1.0f), (Vector3fc)RenderSystem.getModelOffset(), (Matrix4fc)RenderSystem.getTextureMatrix(), RenderSystem.getShaderLineWidth());
        renderType.method_23516();
        RenderSystem.class_5590 autoStorageBuffer = RenderSystem.getSequentialBuffer((VertexFormat.class_5596)renderType.method_23033());
        int indexCount = FixedWidthFontRenderer.TERMINAL_TEXT.method_23033().method_31973(vertexCount);
        GpuBuffer indexBuffer = autoStorageBuffer.method_68274(indexCount);
        class_276 target = class_310.method_1551().method_1522();
        GpuTextureView gpuTextureView = colourTarget = RenderSystem.outputColorTextureOverride != null ? RenderSystem.outputColorTextureOverride : target.method_71639();
        GpuTextureView depthTarget = target.field_1478 ? (RenderSystem.outputDepthTextureOverride != null ? RenderSystem.outputDepthTextureOverride : target.method_71640()) : null;
        try (RenderPass renderPass = RenderSystem.getDevice().createCommandEncoder().createRenderPass(() -> "Monitor", colourTarget, OptionalInt.empty(), depthTarget, OptionalDouble.empty());){
            renderPass.setPipeline(pipeline);
            RenderSystem.bindDefaultUniforms((RenderPass)renderPass);
            renderPass.setUniform("DynamicTransforms", transforms);
            renderPass.setVertexBuffer(0, renderState.vertexBuffer);
            renderPass.setIndexBuffer(indexBuffer, autoStorageBuffer.method_31924());
            for (int j = 0; j < 12; ++j) {
                GpuTextureView gpuTexture = RenderSystem.getShaderTexture((int)j);
                if (gpuTexture == null) continue;
                renderPass.bindSampler("Sampler" + j, gpuTexture);
            }
            renderPass.drawIndexed(vertexOffset, 0, indexCount, 1);
        }
        renderType.method_23518();
    }

    public int method_33893() {
        return Config.monitorDistance;
    }

    public class_238 getRenderBoundingBox(MonitorBlockEntity monitor) {
        return monitor.getRenderBoundingBox();
    }

    private static ByteBuffer getBuffer(int capacity) {
        ByteBuffer buffer = backingBuffer;
        if (buffer == null || buffer.capacity() < capacity) {
            backingBuffer = buffer == null ? MemoryUtil.memAlloc((int)capacity) : MemoryUtil.memRealloc((ByteBuffer)buffer, (int)capacity);
            buffer = backingBuffer;
        }
        buffer.clear();
        return buffer;
    }
}

