/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client.gui;

import dan200.computercraft.client.render.PrintoutRenderer;
import dan200.computercraft.core.terminal.TextBuffer;
import dan200.computercraft.shared.ModRegistry;
import dan200.computercraft.shared.media.PrintoutMenu;
import dan200.computercraft.shared.media.items.PrintoutData;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1712;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_465;
import net.minecraft.class_636;
import net.minecraft.class_8030;
import net.minecraft.class_9322;
import org.joml.Matrix3x2f;
import org.joml.Matrix3x2fc;
import org.jspecify.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public final class PrintoutScreen
extends class_465<PrintoutMenu>
implements class_1712 {
    private PrintoutInfo printout = PrintoutInfo.DEFAULT;
    private int page = 0;

    public PrintoutScreen(PrintoutMenu container, class_1661 player, class_2561 title) {
        super((class_1703)container, player, title);
        this.field_2779 = 209;
    }

    private void setPrintout(class_1799 stack) {
        this.page = 0;
        this.printout = PrintoutInfo.of(PrintoutData.getOrEmpty((class_9322)stack), stack.method_31574((class_1792)ModRegistry.Items.PRINTED_BOOK.get()));
    }

    protected void method_25426() {
        super.method_25426();
        ((PrintoutMenu)this.field_2797).method_7596(this);
    }

    public void method_25432() {
        ((PrintoutMenu)this.field_2797).method_7603(this);
    }

    public void method_7635(class_1703 menu, int slot, class_1799 stack) {
        if (slot == 0) {
            this.setPrintout(stack);
        }
    }

    public void method_7633(class_1703 menu, int slot, int data) {
        if (slot == 0) {
            this.page = data;
        }
    }

    private void setPage(int page) {
        this.page = page;
        class_636 gameMode = Objects.requireNonNull(Objects.requireNonNull(this.field_22787).field_1761);
        gameMode.method_2900(((PrintoutMenu)this.field_2797).field_7763, 100 + page);
    }

    private void previousPage() {
        if (this.page > 0) {
            this.setPage(this.page - 1);
        }
    }

    private void nextPage() {
        if (this.page < this.printout.pages() - 1) {
            this.setPage(this.page + 1);
        }
    }

    public boolean method_25404(int key, int scancode, int modifiers) {
        if (key == 262) {
            this.nextPage();
            return true;
        }
        if (key == 263) {
            this.previousPage();
            return true;
        }
        return super.method_25404(key, scancode, modifiers);
    }

    public boolean method_25401(double x, double y, double deltaX, double deltaY) {
        if (super.method_25401(x, y, deltaX, deltaY)) {
            return true;
        }
        if (deltaY < 0.0) {
            this.nextPage();
            return true;
        }
        if (deltaY > 0.0) {
            this.previousPage();
            return true;
        }
        return false;
    }

    protected void method_2389(class_332 graphics, float partialTicks, int mouseX, int mouseY) {
        graphics.field_59826.method_70922((class_11256)new PrintoutRenderState(this.field_2776 - 12 - 32, this.field_2776 + 172 + 12 + 32, this.field_2800 - 12, this.field_2800 + 209 + 12, this.printout, this.page, new Matrix3x2f((Matrix3x2fc)graphics.method_51448()), graphics.field_44659.method_70863()));
    }

    protected void method_2388(class_332 graphics, int mouseX, int mouseY) {
    }

    @Environment(value=EnvType.CLIENT)
    record PrintoutInfo(int pages, boolean book, TextBuffer[] text, TextBuffer[] colour) {
        public static final PrintoutInfo DEFAULT = PrintoutInfo.of(PrintoutData.EMPTY, false);

        public static PrintoutInfo of(PrintoutData printout, boolean book) {
            TextBuffer[] text = new TextBuffer[printout.lines().size()];
            TextBuffer[] colours = new TextBuffer[printout.lines().size()];
            for (int i = 0; i < text.length; ++i) {
                PrintoutData.Line line = printout.lines().get(i);
                text[i] = new TextBuffer(line.text());
                colours[i] = new TextBuffer(line.foreground());
            }
            int pages = Math.max(text.length / 21, 1);
            return new PrintoutInfo(pages, book, text, colours);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class PrintoutRenderState
    extends Record
    implements class_11256 {
        private final int x0;
        private final int x1;
        private final int y0;
        private final int y1;
        private final PrintoutInfo printout;
        private final int page;
        private final Matrix3x2f pose;
        private final @Nullable class_8030 scissorArea;
        private final @Nullable class_8030 bounds;

        private PrintoutRenderState(int x0, int x1, int y0, int y1, PrintoutInfo printout, int page, Matrix3x2f pose, @Nullable class_8030 scissorArea) {
            this(x0, x1, y0, y1, printout, page, pose, scissorArea, class_11256.method_71535((int)x0, (int)x1, (int)y0, (int)y1, (class_8030)scissorArea));
        }

        public PrintoutRenderState(int x0, int x1, int y0, int y1, PrintoutInfo printout, int page, Matrix3x2f pose, @Nullable class_8030 scissorArea, @Nullable class_8030 bounds) {
            this.x0 = x0;
            this.x1 = x1;
            this.y0 = y0;
            this.y1 = y1;
            this.printout = printout;
            this.page = page;
            this.pose = pose;
            this.scissorArea = scissorArea;
            this.bounds = bounds;
        }

        public float comp_4133() {
            return 1.0f;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{PrintoutRenderState.class, "x0;x1;y0;y1;printout;page;pose;scissorArea;bounds", "x0", "x1", "y0", "y1", "printout", "page", "pose", "scissorArea", "bounds"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{PrintoutRenderState.class, "x0;x1;y0;y1;printout;page;pose;scissorArea;bounds", "x0", "x1", "y0", "y1", "printout", "page", "pose", "scissorArea", "bounds"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{PrintoutRenderState.class, "x0;x1;y0;y1;printout;page;pose;scissorArea;bounds", "x0", "x1", "y0", "y1", "printout", "page", "pose", "scissorArea", "bounds"}, this, o);
        }

        public int comp_4122() {
            return this.x0;
        }

        public int comp_4124() {
            return this.x1;
        }

        public int comp_4123() {
            return this.y0;
        }

        public int comp_4125() {
            return this.y1;
        }

        public PrintoutInfo printout() {
            return this.printout;
        }

        public int page() {
            return this.page;
        }

        public Matrix3x2f method_72127() {
            return this.pose;
        }

        public @Nullable class_8030 comp_4128() {
            return this.scissorArea;
        }

        public @Nullable class_8030 comp_4274() {
            return this.bounds;
        }
    }

    @Environment(value=EnvType.CLIENT)
    public static final class PrintoutPictureRenderer
    extends class_11239<PrintoutRenderState> {
        public PrintoutPictureRenderer(class_4597.class_4598 bufferSource) {
            super(bufferSource);
        }

        protected void renderToTexture(PrintoutRenderState state, class_4587 pose) {
            pose.method_22903();
            pose.method_46416(-86.0f, -221.0f, 0.0f);
            pose.method_22905(1.0f, 1.0f, -1.0f);
            PrintoutRenderer.drawBorder(pose, (class_4597)this.field_59933, 0.0f, 0.0f, 0.0f, state.page(), state.printout().pages(), state.printout().book(), 0xF000F0);
            PrintoutRenderer.drawText(pose, (class_4597)this.field_59933, 13, 11, 21 * state.page(), 0xF000F0, state.printout().text(), state.printout().colour());
            pose.method_22909();
        }

        public Class<PrintoutRenderState> method_70903() {
            return PrintoutRenderState.class;
        }

        protected String method_70906() {
            return "Printout";
        }
    }
}

