/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.client;

import com.mojang.serialization.MapCodec;
import dan200.computercraft.api.client.StandaloneModel;
import dan200.computercraft.api.client.turtle.BasicUpgradeModel;
import dan200.computercraft.api.client.turtle.ItemUpgradeModel;
import dan200.computercraft.api.client.turtle.RegisterTurtleUpgradeModel;
import dan200.computercraft.api.client.turtle.SelectUpgradeModel;
import dan200.computercraft.api.client.turtle.TurtleUpgradeModel;
import dan200.computercraft.client.gui.ComputerScreen;
import dan200.computercraft.client.gui.DiskDriveScreen;
import dan200.computercraft.client.gui.NoTermComputerScreen;
import dan200.computercraft.client.gui.PrinterScreen;
import dan200.computercraft.client.gui.PrintoutScreen;
import dan200.computercraft.client.gui.TurtleScreen;
import dan200.computercraft.client.item.colour.PocketComputerLight;
import dan200.computercraft.client.item.model.TurtleOverlayModel;
import dan200.computercraft.client.item.model.TurtleUpgradeModel;
import dan200.computercraft.client.item.properties.PocketComputerStateProperty;
import dan200.computercraft.client.item.properties.TurtleShowElfOverlay;
import dan200.computercraft.client.platform.ClientPlatformHelper;
import dan200.computercraft.client.platform.ModelKey;
import dan200.computercraft.client.render.CustomLecternRenderer;
import dan200.computercraft.client.render.TurtleBlockEntityRenderer;
import dan200.computercraft.client.render.monitor.MonitorBlockEntityRenderer;
import dan200.computercraft.client.turtle.TurtleOverlay;
import dan200.computercraft.client.turtle.TurtleOverlayManager;
import dan200.computercraft.client.turtle.TurtleUpgradeModelManager;
import dan200.computercraft.shared.ModRegistry;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_10096;
import net.minecraft.class_10401;
import net.minecraft.class_10439;
import net.minecraft.class_10460;
import net.minecraft.class_10494;
import net.minecraft.class_10526;
import net.minecraft.class_1092;
import net.minecraft.class_11239;
import net.minecraft.class_11256;
import net.minecraft.class_1703;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3917;
import net.minecraft.class_3929;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5616;
import net.minecraft.class_7775;

@Environment(value=EnvType.CLIENT)
public final class ClientRegistry {
    private static final Map<class_2960, ModelKey<StandaloneModel>> models = new ConcurrentHashMap<class_2960, ModelKey<StandaloneModel>>();
    private static final class_2960[] EXTRA_MODELS = new class_2960[]{TurtleOverlay.ELF_MODEL, TurtleBlockEntityRenderer.NORMAL_TURTLE_MODEL, TurtleBlockEntityRenderer.ADVANCED_TURTLE_MODEL, TurtleBlockEntityRenderer.COLOUR_TURTLE_MODEL, class_10096.field_53660};

    private ClientRegistry() {
    }

    public static ModelKey<StandaloneModel> getModel(class_2960 model) {
        return models.computeIfAbsent(model, m -> ClientPlatformHelper.get().createModelKey(() -> ((class_2960)m).toString()));
    }

    public static StandaloneModel getModel(class_1092 manager, class_2960 modelId) {
        StandaloneModel model = ClientRegistry.getModel(modelId).get(manager);
        if (model != null) {
            return model;
        }
        return Objects.requireNonNull(ClientRegistry.getModel(class_10096.field_53660).get(manager));
    }

    public static void register() {
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.MONITOR_NORMAL.get()), MonitorBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.MONITOR_ADVANCED.get()), MonitorBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.TURTLE_NORMAL.get()), TurtleBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.TURTLE_ADVANCED.get()), TurtleBlockEntityRenderer::new);
        class_5616.method_32144((class_2591)((class_2591)ModRegistry.BlockEntities.LECTERN.get()), CustomLecternRenderer::new);
    }

    public static void registerMenuScreens(RegisterMenuScreen register) {
        register.register((class_3917)ModRegistry.Menus.COMPUTER.get(), ComputerScreen::new);
        register.register((class_3917)ModRegistry.Menus.POCKET_COMPUTER_NO_TERM.get(), NoTermComputerScreen::new);
        register.register((class_3917)ModRegistry.Menus.TURTLE.get(), TurtleScreen::new);
        register.register((class_3917)ModRegistry.Menus.PRINTER.get(), PrinterScreen::new);
        register.register((class_3917)ModRegistry.Menus.DISK_DRIVE.get(), DiskDriveScreen::new);
        register.register((class_3917)ModRegistry.Menus.PRINTOUT.get(), PrintoutScreen::new);
    }

    public static void registerTurtleModels(RegisterTurtleUpgradeModel register) {
        register.register(BasicUpgradeModel.ID, BasicUpgradeModel.CODEC);
        register.register(ItemUpgradeModel.ID, ItemUpgradeModel.CODEC);
        register.register(SelectUpgradeModel.ID, SelectUpgradeModel.CODEC);
    }

    public static CompletableFuture<ExtraModels> gatherExtraModels(class_3300 resources, Executor executor) {
        CompletableFuture<Map<class_2960, TurtleOverlay.Unbaked>> turtleOverlays = TurtleOverlayManager.loader().load(resources, executor);
        CompletableFuture<Map<class_2960, TurtleUpgradeModel.Unbaked>> turtleUpgrades = TurtleUpgradeModelManager.loader().load(resources, executor);
        return turtleOverlays.thenCombine(turtleUpgrades, ExtraModels::new);
    }

    public static void registerExtraModels(RegisterExtraModels register, ExtraModels models) {
        for (class_2960 model : EXTRA_MODELS) {
            register.register(ClientRegistry.getModel(model), model, (id, r) -> r.markDependency(id), StandaloneModel::of);
        }
        TurtleOverlayManager.loader().register(register, models.turtleOverlays());
        TurtleUpgradeModelManager.loader().register(register, models.turtleUpgrades());
    }

    public static void registerItemModels(BiConsumer<class_2960, MapCodec<? extends class_10439.class_10441>> register) {
        register.accept(TurtleOverlayModel.ID, TurtleOverlayModel.CODEC);
        register.accept(TurtleUpgradeModel.ID, TurtleUpgradeModel.CODEC);
    }

    public static void registerItemColours(BiConsumer<class_2960, MapCodec<? extends class_10401>> register) {
        register.accept(PocketComputerLight.ID, PocketComputerLight.CODEC);
    }

    public static void registerSelectItemProperties(BiConsumer<class_2960, class_10494.class_10495<?, ?>> register) {
        register.accept(PocketComputerStateProperty.ID, PocketComputerStateProperty.TYPE);
    }

    public static void registerConditionalItemProperties(BiConsumer<class_2960, MapCodec<? extends class_10460>> register) {
        register.accept(TurtleShowElfOverlay.ID, TurtleShowElfOverlay.CODEC);
    }

    public static void registerPictureInPictureRenderers(RegisterPictureInPictureRenderer register) {
        register.register(PrintoutScreen.PrintoutRenderState.class, PrintoutScreen.PrintoutPictureRenderer::new);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface RegisterMenuScreen {
        public <M extends class_1703, U extends class_437> void register(class_3917<? extends M> var1, class_3929.class_3930<M, U> var2);
    }

    @Environment(value=EnvType.CLIENT)
    public static interface RegisterExtraModels {
        default public <U extends class_10526, T> void register(ModelKey<T> key, U unbaked, BiFunction<U, class_7775, T> bake) {
            this.register(key, unbaked, class_10526::method_62326, bake);
        }

        public <U, T> void register(ModelKey<T> var1, U var2, BiConsumer<U, class_10526.class_10103> var3, BiFunction<U, class_7775, T> var4);
    }

    @Environment(value=EnvType.CLIENT)
    public record ExtraModels(Map<class_2960, TurtleOverlay.Unbaked> turtleOverlays, Map<class_2960, TurtleUpgradeModel.Unbaked> turtleUpgrades) {
    }

    @Environment(value=EnvType.CLIENT)
    public static interface RegisterPictureInPictureRenderer {
        public <T extends class_11256> void register(Class<T> var1, Function<class_4597.class_4598, class_11239<T>> var2);
    }
}

