/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.inventoryessentials;

import java.util.HashSet;
import java.util.Set;
import net.blay09.mods.inventoryessentials.data.IgnoredData;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerMenuAccessor;
import net.blay09.mods.inventoryessentials.mixin.AbstractContainerScreenAccessor;
import net.blay09.mods.inventoryessentials.mixin.CreativeModeInventoryScreenAccessor;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1734;
import net.minecraft.class_1735;
import net.minecraft.class_2960;
import net.minecraft.class_3917;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

public class InventoryEssentialsIgnores {
    private static final Set<String> ignoredScreenClasses = new HashSet<String>();
    private static final Set<String> ignoredMenuClasses = new HashSet<String>();
    private static final Set<String> ignored = new HashSet<String>();
    private static final Set<class_2960> ignoredMenuTypes = new HashSet<class_2960>();

    public static boolean shouldIgnoreScreen(class_437 screen) {
        class_2960 typeId;
        if (!(screen instanceof AbstractContainerScreenAccessor)) {
            return true;
        }
        if (ignoredScreenClasses.contains(screen.getClass().getName())) {
            return true;
        }
        class_1703 menu = ((class_465)screen).method_17577();
        if (ignoredMenuClasses.contains(menu.getClass().getName())) {
            return true;
        }
        class_3917<?> menuType = ((AbstractContainerMenuAccessor)menu).balm$getMenuType();
        class_2960 class_29602 = typeId = menuType != null ? class_7923.field_41187.method_10221(menuType) : null;
        return typeId != null && ignoredMenuTypes.contains(typeId);
    }

    public static boolean shouldIgnoreSlot(class_465<?> screen, @Nullable class_1735 slot) {
        if (slot == null) {
            return true;
        }
        if (ignored.contains(slot.getClass().getName())) {
            return true;
        }
        if (slot instanceof class_1734) {
            return true;
        }
        if (screen instanceof CreativeModeInventoryScreenAccessor) {
            CreativeModeInventoryScreenAccessor creativeAccessor = (CreativeModeInventoryScreenAccessor)screen;
            return !(slot.field_7871 instanceof class_1661) && slot.field_7871 == creativeAccessor.getCONTAINER();
        }
        return false;
    }

    public static void addIgnoredMenuType(class_2960 menuId) {
        ignoredMenuTypes.add(menuId);
    }

    public static void addIgnoredMenuClass(String menuClass) {
        ignoredMenuClasses.add(menuClass);
    }

    public static void addIgnoredScreenClass(String screenClass) {
        ignoredScreenClasses.add(screenClass);
    }

    public static void addIgnoredSlotClass(String slotClass) {
        ignored.add(slotClass);
    }

    public static void addIgnoredData(IgnoredData ignoredData) {
        ignoredData.ignoredMenuClasses.forEach(InventoryEssentialsIgnores::addIgnoredMenuClass);
        ignoredData.ignoredMenuTypes.stream().map(class_2960::method_60654).forEach(InventoryEssentialsIgnores::addIgnoredMenuType);
        ignoredData.ignoredScreenClasses.forEach(InventoryEssentialsIgnores::addIgnoredScreenClass);
        ignoredData.ignoredSlotClasses.forEach(InventoryEssentialsIgnores::addIgnoredSlotClass);
    }
}

