/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_2561;

public final class Translations {
    private static final Map<String, String> FALLBACKS = Translations.loadFallbacks();
    private static final String EMBEDDED_EN_US = "{\n    \"key.veinminer.toggle\": \"Toggle Veinminer\",\n    \"key.veinminer.activate\": \"Activate Veinminer\",\n    \"category.veinminer\": \"Veinminer\",\n    \"command.veinminer.enabled\": \"enabled\",\n    \"command.veinminer.disabled\": \"disabled\",\n    \"command.veinminer.list_entry\": \"- %s\",\n    \"command.veinminer.block_list_type.global_whitelist\": \"global whitelist\",\n    \"command.veinminer.block_list_type.per_tool_whitelist\": \"per-tool whitelist\",\n    \"command.veinminer.block_list_type.global_blacklist\": \"global blacklist\",\n    \"command.veinminer.block_list_type.per_tool_blacklist\": \"per-tool blacklist\",\n    \"command.veinminer.block_list_type.whitelist\": \"whitelist\",\n    \"command.veinminer.block_list_type.blacklist\": \"blacklist\",\n    \"command.veinminer.blockpertool.block_added\": \"Block ID %s added to the %s for tool %s.\",\n    \"command.veinminer.blockpertool.block_exists\": \"Block ID %s is already in the %s.\",\n    \"command.veinminer.blockpertool.block_removed\": \"Block ID %s removed from the %s for tool %s.\",\n    \"command.veinminer.blockpertool.block_not_found\": \"Block ID %s is not present in the %s for tool %s.\",\n    \"command.veinminer.blockpertool.no_blocks\": \"No entries in the %s for tool %s.\",\n    \"command.veinminer.blockpertool.blocks_for_tool\": \"%s entries for tool %s:\",\n    \"command.veinminer.blockpertool.tool_exists\": \"Tool ID %s already exists.\",\n    \"command.veinminer.blockpertool.tool_added\": \"Tool ID %s added.\",\n    \"command.veinminer.blockpertool.tool_removed\": \"Tool ID %s removed.\",\n    \"command.veinminer.blockpertool.tool_not_found\": \"Tool ID %s not found.\",\n    \"command.veinminer.blockpertool.no_tools\": \"No tools found.\",\n    \"command.veinminer.blockpertool.tools_header\": \"Tools:\",\n    \"command.veinminer.blockpertool.not_enabled\": \"Per-tool block lists are disabled. Use /veinminer settings blockpertool or blocklistmode to enable them.\",\n    \"command.veinminer.blockpertool.blocks_cleared\": \"Cleared all %s entries for tool %s.\",\n    \"command.veinminer.blockpertool.tools_cleared\": \"Cleared all per-tool %s entries.\",\n    \"command.veinminer.blocks.added\": \"Block ID %s added to the %s.\",\n    \"command.veinminer.blocks.exists\": \"Block ID %s is already in the %s.\",\n    \"command.veinminer.blocks.removed\": \"Block ID %s removed from the %s.\",\n    \"command.veinminer.blocks.not_found\": \"Block ID %s is not in the %s.\",\n    \"command.veinminer.blocks.none\": \"No entries in the %s.\",\n    \"command.veinminer.blocks.header\": \"%s entries:\",\n    \"command.veinminer.blocks.per_tool_hint\": \"Per-tool block list mode is active; this global list is currently ignored.\",\n    \"command.veinminer.blocks.cleared\": \"Cleared all entries from the %s.\",\n    \"command.veinminer.tools.added\": \"Tool ID %s added to Veinminer.\",\n    \"command.veinminer.tools.exists\": \"Tool ID %s is already in the list.\",\n    \"command.veinminer.tools.removed\": \"Tool ID %s removed from Veinminer.\",\n    \"command.veinminer.tools.not_found\": \"Tool ID %s is not in the list.\",\n    \"command.veinminer.tools.none\": \"No tools in the list.\",\n    \"command.veinminer.tools.header\": \"Allowed tools:\",\n    \"command.veinminer.tools.cleared\": \"Cleared all allowed tools.\",\n    \"command.veinminer.settings.blockpertool\": \"BlockPerTool is now %s. The block list mode is using %s.\",\n    \"command.veinminer.settings.cooldown_time_set\": \"Cooldown time set to %s seconds\",\n    \"command.veinminer.settings.cooldown_state\": \"Cooldown is now %s\",\n    \"command.veinminer.settings.luckperms_state\": \"LuckPerms integration %s\",\n    \"command.veinminer.settings.max_blocks_set\": \"Max blocks set to %s\",\n    \"command.veinminer.settings.blocklistmode_set\": \"Block list mode set to %s.\",\n    \"command.veinminer.settings.blocklistmode_invalid\": \"Unknown block list mode '%s'. Use whitelist or blacklist.\",\n    \"command.veinminer.settings.show.max_blocks\": \"Max Blocks: %s\",\n    \"command.veinminer.settings.show.cooldown_enabled\": \"Cooldown Enabled: %s\",\n    \"command.veinminer.settings.show.cooldown_time\": \"Cooldown Time: %s seconds\",\n    \"command.veinminer.settings.show.block_list_mode\": \"Block List Mode: %s\",\n    \"command.veinminer.activation.keybind\": \"Keybind usage is now %s.\",\n    \"command.veinminer.activation.keybind.client_required\": \"The client mod is required to use keybind activation commands.\",\n    \"command.veinminer.activation.mode\": \"Activation mode set to %s.\",\n    \"command.veinminer.activation.mode.hold\": \"hold\",\n    \"command.veinminer.activation.mode.toggle\": \"toggle\",\n    \"command.veinminer.toggle\": \"Veinminer is now %s.\",\n    \"command.veinminer.player_only\": \"This command can only be used by players.\",\n    \"command.veinminer.particles_player_toggle\": \"Particles is now %s for you.\",\n    \"command.veinminer.togglemessage\": \"%s messages are now %s for you.\",\n    \"command.veinminer.reload\": \"Veinminer config reloaded.\",\n    \"command.veinminer.reload_failed\": \"Failed to reload config %s at line %s: %s\",\n    \"command.veinminer.confirm.prompt\": \"Please run /veinminer confirm to proceed with this clear. If you do not want to clear either wait 10 seconds and it will cancel or run /veinminer cancel.\",\n    \"command.veinminer.confirm.none\": \"There is no pending action to confirm.\",\n    \"command.veinminer.confirm.cancelled\": \"Pending action cancelled.\",\n    \"command.veinminer.confirm.expired\": \"Pending action timed out.\",\n    \"command.veinminer.help\": \"Use /veinminer help <topic>. Topics: toggle, blocks, blockpertool, tools, settings, activation, togglemessages, particles, reload.\",\n    \"command.veinminer.help.toggle\": \"/veinminer toggle - Toggle Veinminer for yourself. /veinminer toggleparticles - Toggle client particles.\",\n    \"command.veinminer.help.blocks\": \"/veinminer blocks list|add|remove|clear <id|#tag> - Manage the global block list (honors blockListMode). Example: /veinminer blocks add minecraft:diamond_ore\",\n    \"command.veinminer.help.blockpertool\": \"/veinminer blockpertool blocks <tool|#tag|hand> list|add|remove|clear <id|#tag> - Manage per-tool lists when per-tool blockListMode is active. /veinminer blockpertool tool add|remove|list|clear - Manage tool entries.\",\n    \"command.veinminer.help.tools\": \"/veinminer tools list|add|remove|clear <id|#tag|hand> - Control which tools can veinmine.\",\n    \"command.veinminer.help.settings\": \"/veinminer settings blocklistmode whitelist|blacklist | blockpertool | maxblocks <n> | cooldown enable|disable|set <seconds> | luckperms enable|disable - Adjust server settings.\",\n    \"command.veinminer.help.activation\": \"/veinminer activation keybind (client mod only) | mode hold|toggle - Personal activation preferences.\",\n    \"command.veinminer.help.togglemessages\": \"/veinminer togglemessages <permission|disabled|cooldown|durability> - Toggle specific chat notifications.\",\n    \"command.veinminer.help.particles\": \"/veinminer particles toggle|setcolor <r g b>|setduration <ticks> - Server particle outline settings.\",\n    \"command.veinminer.help.reload\": \"/veinminer reload - Reload configs from disk.\",\n    \"command.veinminer.particles.toggle\": \"Particles toggled %s.\",\n    \"command.veinminer.particles.color_set\": \"Particle color set\",\n    \"command.veinminer.particles.duration_set\": \"Particle duration set to %s ticks.\",\n    \"command.veinminer.test.busy\": \"A feature test run is already in progress.\",\n    \"command.veinminer.test.starting\": \"Starting Veinminer feature test harness...\",\n    \"command.veinminer.test.running\": \"Executing scripted checks...\",\n    \"command.veinminer.test.summary\": \"Feature test complete: %s/%s steps passed.\",\n    \"command.veinminer.test.step.pass\": \"- %s\",\n    \"command.veinminer.test.step.fail\": \"x %s - %s\",\n    \"command.veinminer.test.player_only\": \"Feature tests can only be run by an in-game player.\",\n    \"message.veinminer.no_permission\": \"You do not have permission to use Veinminer!\",\n    \"message.veinminer.disabled\": \"Veinminer is disabled. Use /veinminer toggle to enable it.\",\n    \"message.veinminer.cooldown\": \"Veinminer is on cooldown!\",\n    \"message.veinminer.low_durability\": \"Tool durability too low for Veinminer!\",\n    \"message.veinminer.limit_durability\": \"Found %s blocks, only broke %s due to low durability.\"\n}\n";

    private Translations() {
    }

    public static class_2561 translate(String key, Object ... args) {
        String fallback = FALLBACKS.getOrDefault(key, key);
        return class_2561.method_48322((String)key, (String)fallback, (Object[])args);
    }

    private static Map<String, String> loadFallbacks() {
        Map<String, String> resourceFallbacks = Translations.readJson(Translations.class.getResourceAsStream("/assets/veinminermod/lang/en_us.json"));
        if (!resourceFallbacks.isEmpty()) {
            return resourceFallbacks;
        }
        Map<String, String> embeddedFallbacks = Translations.readJson(new ByteArrayInputStream(EMBEDDED_EN_US.getBytes(StandardCharsets.UTF_8)));
        return Collections.unmodifiableMap(embeddedFallbacks);
    }

    private static Map<String, String> readJson(InputStream stream) {
        Map map;
        if (stream == null) {
            return Map.of();
        }
        InputStreamReader reader = new InputStreamReader(stream, StandardCharsets.UTF_8);
        try {
            JsonObject json = (JsonObject)new Gson().fromJson((Reader)reader, JsonObject.class);
            HashMap<String, String> map2 = new HashMap<String, String>(json.size());
            for (Map.Entry entry : json.entrySet()) {
                map2.put((String)entry.getKey(), ((JsonElement)entry.getValue()).getAsString());
            }
            map = map2.isEmpty() ? Map.of() : Collections.unmodifiableMap(map2);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception ex) {
                return Map.of();
            }
        }
        reader.close();
        return map;
    }
}

