/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.testing;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.logic.VeinMinerController;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.util.Translations;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class FeatureTestHarness {
    private final Bootstrap bootstrap;
    private boolean running;
    private static final Method FIND_VEIN = FeatureTestHarness.lookupFindVein();
    private static final Method APPLY_PLAN = FeatureTestHarness.lookupApplyPlan();
    private static final Method COMPUTE_BLOCK_CAP = FeatureTestHarness.lookupComputeBlockCap();

    public FeatureTestHarness(Bootstrap bootstrap) {
        this.bootstrap = Objects.requireNonNull(bootstrap, "bootstrap");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean start(class_2168 source) {
        boolean bl;
        boolean hadClientMod;
        class_3222 player;
        block14: {
            class_3222 playerEntity;
            PlayerSettingsStore store;
            PlayerSnapshot snapshot;
            block12: {
                boolean bl2;
                block13: {
                    if (!this.acquire()) {
                        return false;
                    }
                    player = null;
                    snapshot = null;
                    store = this.bootstrap.playerSettings();
                    hadClientMod = false;
                    class_1297 class_12972 = source.method_9228();
                    if (class_12972 instanceof class_3222) {
                        playerEntity = (class_3222)class_12972;
                        break block12;
                    }
                    source.method_9213(Translations.translate("command.veinminer.test.player_only", new Object[0]));
                    Log.warn("Feature test aborted: non-player source '{}'", source.method_9214());
                    bl2 = true;
                    if (snapshot == null || player == null) break block13;
                    snapshot.restore(store, player);
                    store.saveAsync();
                }
                if (player != null && !hadClientMod) {
                    this.bootstrap.keyStates().unregister(player);
                }
                this.release();
                return bl2;
            }
            try {
                player = playerEntity;
                hadClientMod = this.bootstrap.keyStates().hasClient(player);
                this.bootstrap.keyStates().registerClient(player);
                snapshot = PlayerSnapshot.capture(store, player);
                source.method_9226(() -> Translations.translate("command.veinminer.test.starting", new Object[0]), false);
                source.method_9226(() -> Translations.translate("command.veinminer.test.running", new Object[0]), false);
                Log.info("Feature test harness invoked by {}", player.method_5477().getString());
                TestContext context = new TestContext(this.bootstrap, source, player, store);
                List<TestStep> steps = this.createSteps();
                ArrayList<TestResult> results = new ArrayList<TestResult>(steps.size());
                for (TestStep step : steps) {
                    results.add(this.runStep(step, context));
                }
                long passed = results.stream().filter(TestResult::success).count();
                source.method_9226(() -> Translations.translate("command.veinminer.test.summary", passed, steps.size()), false);
                Log.info("Feature test harness completed with {}/{} successes", passed, steps.size());
                for (TestResult result : results) {
                    if (result.success()) {
                        source.method_9226(() -> Translations.translate("command.veinminer.test.step.pass", result.name()), false);
                        continue;
                    }
                    source.method_9213(Translations.translate("command.veinminer.test.step.fail", result.name(), result.message()));
                    Log.warn("Feature test step '{}' failed: {}", result.name(), result.message());
                }
                bl = true;
                if (snapshot == null || player == null) break block14;
                snapshot.restore(store, player);
                store.saveAsync();
            }
            catch (Throwable throwable) {
                if (snapshot != null && player != null) {
                    snapshot.restore(store, player);
                    store.saveAsync();
                }
                if (player != null && !hadClientMod) {
                    this.bootstrap.keyStates().unregister(player);
                }
                this.release();
                throw throwable;
            }
        }
        if (player != null && !hadClientMod) {
            this.bootstrap.keyStates().unregister(player);
        }
        this.release();
        return bl;
    }

    private synchronized boolean acquire() {
        if (this.running) {
            return false;
        }
        this.running = true;
        return true;
    }

    private synchronized void release() {
        this.running = false;
    }

    private List<TestStep> createSteps() {
        ArrayList<TestStep> steps = new ArrayList<TestStep>();
        steps.add(new TestStep("Veinminer Toggle", ctx -> {
            boolean before = ctx.store().isVeinminerEnabled(ctx.player());
            ctx.expectCommandSuccess("veinminer toggle");
            boolean after = ctx.store().isVeinminerEnabled(ctx.player());
            ctx.assertEquals(!before, after, "Veinminer toggle did not invert player state");
        }));
        steps.add(new TestStep("Particle Toggle", ctx -> {
            boolean before = ctx.store().isParticlesEnabled(ctx.player());
            ctx.expectCommandSuccess("veinminer toggleparticles");
            boolean after = ctx.store().isParticlesEnabled(ctx.player());
            ctx.assertEquals(!before, after, "Particle toggle did not invert player state");
        }));
        steps.add(new TestStep("Permission Message Toggle", ctx -> {
            boolean before = ctx.store().isMessageEnabled(ctx.player(), PlayerSettingsStore.MessageType.PERMISSION);
            ctx.expectCommandSuccess("veinminer togglemessages permission");
            boolean after = ctx.store().isMessageEnabled(ctx.player(), PlayerSettingsStore.MessageType.PERMISSION);
            ctx.assertEquals(!before, after, "Message toggle did not invert permission message state");
        }));
        steps.add(new TestStep("Keybind Toggle Off", ctx -> {
            PlayerSettingsStore store = ctx.store();
            store.setUseKeybind(ctx.player(), true);
            store.resetKeyToggleState(ctx.player());
            ctx.expectCommandSuccess("veinminer activation keybind");
            ctx.assertTrue(!store.useKeybind(ctx.player()), "Keybind toggle did not disable keybind usage");
        }));
        steps.add(new TestStep("Keybind Toggle On", ctx -> {
            PlayerSettingsStore store = ctx.store();
            store.setUseKeybind(ctx.player(), false);
            store.resetKeyToggleState(ctx.player());
            ctx.expectCommandSuccess("veinminer activation keybind");
            ctx.assertTrue(store.useKeybind(ctx.player()), "Keybind toggle did not enable keybind usage");
        }));
        steps.add(new TestStep("Activation Mode Toggle", ctx -> {
            ctx.expectCommandSuccess("veinminer activation mode toggle");
            ctx.assertTrue(ctx.store().keyToggleMode(ctx.player()), "Activation mode toggle did not enable key toggle");
            ctx.assertTrue(ctx.store().crouchToggleMode(ctx.player()), "Activation mode toggle did not enable crouch toggle");
        }));
        steps.add(new TestStep("Activation Mode Hold", ctx -> {
            ctx.expectCommandSuccess("veinminer activation mode hold");
            ctx.assertTrue(!ctx.store().keyToggleMode(ctx.player()), "Activation mode hold did not switch keybind to hold");
            ctx.assertTrue(!ctx.store().crouchToggleMode(ctx.player()), "Activation mode hold did not switch crouch to hold");
        }));
        steps.add(new TestStep("World Veinminer Simulation", this::runWorldSimulation));
        steps.add(new TestStep("Config Reload", ctx -> ctx.expectCommandSuccess("veinminer reload")));
        return steps;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runWorldSimulation(TestContext ctx) throws Exception {
        VeinMinerController controller = this.bootstrap.controller();
        ConfigService.ConfigSnapshot snapshot = this.bootstrap.configService().snapshot();
        MinecraftServer server = ctx.server();
        class_3218 world = server.method_30002();
        class_2338 origin = ctx.player().method_24515().method_10084();
        List<class_2338> cluster = List.of(origin, origin.method_10078(), origin.method_10084());
        HashMap<class_2338, class_2680> originalStates = new HashMap<class_2338, class_2680>();
        for (class_2338 pos : cluster) {
            originalStates.put(pos, world.method_8320(pos));
            world.method_8652(pos, class_2246.field_10212.method_9564(), 3);
        }
        boolean originalSneaking = ctx.player().method_5715();
        class_1799 originalMainHand = ctx.player().method_6047().method_7972();
        class_1799 tool = new class_1799((class_1935)class_1802.field_8403);
        ctx.player().method_6122(class_1268.field_5808, tool);
        ctx.player().method_5660(snapshot.general().requireCrouch());
        PlayerSettingsStore store = ctx.store();
        store.setVeinminerEnabled(ctx.player(), true);
        store.setParticlesEnabled(ctx.player(), false);
        store.setUseKeybind(ctx.player(), false);
        store.setKeyToggleMode(ctx.player(), false);
        store.resetKeyToggleState(ctx.player());
        store.setCrouchToggleMode(ctx.player(), false);
        store.setCrouchToggleState(ctx.player(), snapshot.general().requireCrouch());
        store.setLastCrouchInput(ctx.player(), snapshot.general().requireCrouch());
        try {
            int reserve = snapshot.general().durabilityReserveFor(tool.method_7936());
            int remaining = tool.method_7936() - tool.method_7919();
            int limit = (Integer)COMPUTE_BLOCK_CAP.invoke((Object)controller, tool, remaining, reserve);
            Object plan = FIND_VEIN.invoke((Object)controller, world, origin, world.method_8320(origin), limit, 0, tool.method_7972());
            APPLY_PLAN.invoke((Object)controller, world, ctx.player(), tool, plan, reserve);
            for (class_2338 pos : cluster) {
                ctx.assertTrue(world.method_8320(pos).method_26215(), "Expected block at " + String.valueOf(pos) + " to be mined");
            }
            this.clearEntities(world, cluster);
        }
        finally {
            ctx.player().method_6122(class_1268.field_5808, originalMainHand);
            ctx.player().method_5660(originalSneaking);
            for (Map.Entry entry : originalStates.entrySet()) {
                world.method_8652((class_2338)entry.getKey(), (class_2680)entry.getValue(), 3);
            }
        }
    }

    private void clearEntities(class_3218 world, List<class_2338> cluster) {
        class_2338 origin = cluster.get(0);
        class_238 area = new class_238(origin).method_1014(2.0);
        for (class_1542 item : world.method_8390(class_1542.class, area, entity -> true)) {
            item.method_31472();
        }
        for (class_1303 orb : world.method_8390(class_1303.class, area, entity -> true)) {
            orb.method_31472();
        }
    }

    private TestResult runStep(TestStep step, TestContext context) {
        try {
            step.action().run(context);
            return TestResult.success(step.name());
        }
        catch (AssertionError ex) {
            return TestResult.failure(step.name(), ((Throwable)((Object)ex)).getMessage());
        }
        catch (CommandSyntaxException ex) {
            return TestResult.failure(step.name(), ex.getMessage());
        }
        catch (Exception ex) {
            String message = ex.getMessage() != null ? ex.getMessage() : ex.getClass().getSimpleName();
            return TestResult.failure(step.name(), message);
        }
    }

    private static Method lookupFindVein() {
        try {
            Method method = VeinMinerController.class.getDeclaredMethod("findVein", class_3218.class, class_2338.class, class_2680.class, Integer.TYPE, Integer.TYPE, class_1799.class);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Unable to access VeinMinerController#findVein", ex);
        }
    }

    private static Method lookupApplyPlan() {
        try {
            Class<?> veinPlanClass = FIND_VEIN.getReturnType();
            Method method = VeinMinerController.class.getDeclaredMethod("applyPlan", class_3218.class, class_3222.class, class_1799.class, veinPlanClass, Integer.TYPE);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Unable to access VeinMinerController#applyPlan", ex);
        }
    }

    private static Method lookupComputeBlockCap() {
        try {
            Method method = VeinMinerController.class.getDeclaredMethod("computeBlockCap", class_1799.class, Integer.TYPE, Integer.TYPE);
            method.setAccessible(true);
            return method;
        }
        catch (ReflectiveOperationException ex) {
            throw new IllegalStateException("Unable to access VeinMinerController#computeBlockCap", ex);
        }
    }

    private static final class PlayerSnapshot {
        private final boolean veinminerEnabled;
        private final boolean particlesEnabled;
        private final Map<PlayerSettingsStore.MessageType, Boolean> messages;
        private final boolean useKeybind;
        private final boolean keyToggleMode;
        private final boolean keyToggleActive;
        private final boolean crouchToggleMode;
        private final boolean crouchToggleActive;
        private final boolean lastCrouchInput;

        private PlayerSnapshot(boolean veinminerEnabled, boolean particlesEnabled, Map<PlayerSettingsStore.MessageType, Boolean> messages, boolean useKeybind, boolean keyToggleMode, boolean keyToggleActive, boolean crouchToggleMode, boolean crouchToggleActive, boolean lastCrouchInput) {
            this.veinminerEnabled = veinminerEnabled;
            this.particlesEnabled = particlesEnabled;
            this.messages = messages;
            this.useKeybind = useKeybind;
            this.keyToggleMode = keyToggleMode;
            this.keyToggleActive = keyToggleActive;
            this.crouchToggleMode = crouchToggleMode;
            this.crouchToggleActive = crouchToggleActive;
            this.lastCrouchInput = lastCrouchInput;
        }

        static PlayerSnapshot capture(PlayerSettingsStore store, class_3222 player) {
            EnumMap<PlayerSettingsStore.MessageType, Boolean> messages = new EnumMap<PlayerSettingsStore.MessageType, Boolean>(PlayerSettingsStore.MessageType.class);
            for (PlayerSettingsStore.MessageType type : PlayerSettingsStore.MessageType.values()) {
                messages.put(type, store.isMessageEnabled(player, type));
            }
            return new PlayerSnapshot(store.isVeinminerEnabled(player), store.isParticlesEnabled(player), messages, store.useKeybind(player), store.keyToggleMode(player), store.isKeyToggleActive(player), store.crouchToggleMode(player), store.isCrouchToggleActive(player), store.lastCrouchInput(player));
        }

        void restore(PlayerSettingsStore store, class_3222 player) {
            store.setVeinminerEnabled(player, this.veinminerEnabled);
            store.setParticlesEnabled(player, this.particlesEnabled);
            for (Map.Entry<PlayerSettingsStore.MessageType, Boolean> entry : this.messages.entrySet()) {
                store.setMessageEnabled(player, entry.getKey(), entry.getValue());
            }
            store.setUseKeybind(player, this.useKeybind);
            store.setKeyToggleMode(player, this.keyToggleMode);
            store.setKeyToggleState(player, this.keyToggleActive);
            store.setCrouchToggleMode(player, this.crouchToggleMode);
            store.setCrouchToggleState(player, this.crouchToggleActive);
            store.setLastCrouchInput(player, this.lastCrouchInput);
        }
    }

    private static final class TestContext {
        private final Bootstrap bootstrap;
        private final class_2168 source;
        private final class_3222 player;
        private final PlayerSettingsStore store;
        private final CommandDispatcher<class_2168> dispatcher;

        TestContext(Bootstrap bootstrap, class_2168 source, class_3222 player, PlayerSettingsStore store) {
            this.bootstrap = bootstrap;
            this.source = source;
            this.player = player;
            this.store = store;
            this.dispatcher = source.method_9211().method_3734().method_9235();
        }

        Bootstrap bootstrap() {
            return this.bootstrap;
        }

        class_3222 player() {
            return this.player;
        }

        PlayerSettingsStore store() {
            return this.store;
        }

        MinecraftServer server() {
            return this.source.method_9211();
        }

        void expectCommandSuccess(String command) throws CommandSyntaxException {
            int result = this.dispatcher.execute(command, (Object)this.source);
            if (result <= 0) {
                throw new AssertionError((Object)("Command '" + command + "' completed with result " + result));
            }
        }

        void assertTrue(boolean condition, String message) {
            if (!condition) {
                throw new AssertionError((Object)message);
            }
        }

        void assertEquals(boolean expected, boolean actual, String message) {
            if (expected != actual) {
                throw new AssertionError((Object)(message + " (expected: " + expected + ", actual: " + actual + ")"));
            }
        }
    }

    private record TestStep(String name, TestAction action) {
    }

    private record TestResult(String name, boolean success, String message) {
        static TestResult success(String name) {
            return new TestResult(name, true, "");
        }

        static TestResult failure(String name, String message) {
            return new TestResult(name, false, message);
        }
    }

    @FunctionalInterface
    private static interface TestAction {
        public void run(TestContext var1) throws Exception;
    }
}

