/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.state;

import com.sheath.veinminer.util.Translations;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.class_2168;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class ClearConfirmationManager {
    private static final long TIMEOUT_MILLIS = 10000L;
    private final Map<String, PendingAction> pending = new HashMap<String, PendingAction>();

    public synchronized void request(class_2168 source, Consumer<class_2168> action) {
        this.pending.put(ClearConfirmationManager.keyFor(source), new PendingAction(source, action, System.currentTimeMillis() + 10000L));
        source.method_9226(() -> Translations.translate("command.veinminer.confirm.prompt", new Object[0]), false);
    }

    public synchronized int confirm(class_2168 source) {
        PendingAction action = this.pending.remove(ClearConfirmationManager.keyFor(source));
        if (action == null) {
            source.method_9213(Translations.translate("command.veinminer.confirm.none", new Object[0]));
            return 0;
        }
        if (action.isExpired()) {
            action.notifyExpired();
            return 0;
        }
        action.run(source);
        return 1;
    }

    public synchronized int cancel(class_2168 source) {
        PendingAction action = this.pending.remove(ClearConfirmationManager.keyFor(source));
        if (action == null) {
            source.method_9213(Translations.translate("command.veinminer.confirm.none", new Object[0]));
            return 0;
        }
        action.notifyCancelled();
        return 1;
    }

    public synchronized void tick(MinecraftServer server) {
        long now = System.currentTimeMillis();
        Iterator<Map.Entry<String, PendingAction>> iterator = this.pending.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, PendingAction> entry = iterator.next();
            if (entry.getValue().expiresAt > now) continue;
            PendingAction action = entry.getValue();
            iterator.remove();
            action.notifyExpired();
        }
    }

    private static String keyFor(class_2168 source) {
        try {
            class_3222 player = source.method_44023();
            if (player != null) {
                return "player:" + player.method_5845();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return "source:" + source.method_9214();
    }

    private static final class PendingAction {
        private final class_2168 feedbackTarget;
        private final Consumer<class_2168> action;
        private final long expiresAt;

        PendingAction(class_2168 feedbackTarget, Consumer<class_2168> action, long expiresAt) {
            this.feedbackTarget = feedbackTarget;
            this.action = action;
            this.expiresAt = expiresAt;
        }

        boolean isExpired() {
            return System.currentTimeMillis() >= this.expiresAt;
        }

        void run(class_2168 source) {
            this.action.accept(source);
        }

        void notifyExpired() {
            this.feedbackTarget.method_9226(() -> Translations.translate("command.veinminer.confirm.expired", new Object[0]), false);
        }

        void notifyCancelled() {
            this.feedbackTarget.method_9226(() -> Translations.translate("command.veinminer.confirm.cancelled", new Object[0]), false);
        }
    }
}

