/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.permission;

import com.sheath.veinminer.util.Log;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.luckperms.api.LuckPerms;
import net.luckperms.api.LuckPermsProvider;
import net.luckperms.api.model.user.User;
import net.luckperms.api.util.Tristate;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;

public final class PermissionService {
    private LuckPerms luckPerms;
    private final Map<UUID, User> cache = new ConcurrentHashMap<UUID, User>();

    public void configure(boolean enableLuckPerms) {
        if (!enableLuckPerms) {
            this.luckPerms = null;
            this.cache.clear();
            Log.info("LuckPerms integration disabled", new Object[0]);
            return;
        }
        try {
            Class.forName("net.luckperms.api.LuckPermsProvider");
            this.luckPerms = LuckPermsProvider.get();
            this.cache.clear();
            Log.info("LuckPerms detected, permissions will use its data", new Object[0]);
        }
        catch (ClassNotFoundException | IllegalStateException ex) {
            this.luckPerms = null;
            this.cache.clear();
            Log.info("LuckPerms not available, falling back to operator checks", new Object[0]);
        }
    }

    public boolean hasPermission(class_3222 player, String permission) {
        MinecraftServer server = this.resolveServer(player);
        if (server != null && server.method_3724()) {
            return true;
        }
        boolean isUsePermission = "veinminer.use".equalsIgnoreCase(permission);
        if (this.luckPerms == null) {
            return isUsePermission || player.method_64475(2);
        }
        try {
            User user = this.cache.computeIfAbsent(player.method_5667(), uuid -> this.loadUser((UUID)uuid));
            if (user == null || user.getCachedData() == null || user.getCachedData().getPermissionData() == null) {
                return isUsePermission || player.method_64475(2);
            }
            Tristate result = user.getCachedData().getPermissionData().checkPermission(permission);
            if (result == Tristate.FALSE) {
                return false;
            }
            if (result == Tristate.UNDEFINED) {
                return isUsePermission || player.method_64475(2);
            }
            return true;
        }
        catch (Exception ex) {
            Log.warn("Permission check failed for {}: {}", player.method_5477().getString(), ex.getMessage());
            return isUsePermission || player.method_64475(2);
        }
    }

    private MinecraftServer resolveServer(class_3222 player) {
        try {
            return player.method_51469().method_8503();
        }
        catch (Exception exception) {
            try {
                return player.method_64396().method_9211();
            }
            catch (Exception exception2) {
                for (String getter : new String[]{"getEntityWorld", "getServerWorld", "getServer"}) {
                    try {
                        Object server;
                        Object worldOrServer = player.getClass().getMethod(getter, new Class[0]).invoke((Object)player, new Object[0]);
                        if (worldOrServer instanceof MinecraftServer) {
                            MinecraftServer mcServer = (MinecraftServer)worldOrServer;
                            return mcServer;
                        }
                        if (worldOrServer == null || !((server = worldOrServer.getClass().getMethod("getServer", new Class[0]).invoke(worldOrServer, new Object[0])) instanceof MinecraftServer)) continue;
                        MinecraftServer mcServer = (MinecraftServer)server;
                        return mcServer;
                    }
                    catch (Exception exception3) {
                        // empty catch block
                    }
                }
                return null;
            }
        }
    }

    private UUID extractUuid(Object profile) {
        try {
            Object id = profile.getClass().getMethod("getId", new Class[0]).invoke(profile, new Object[0]);
            return id instanceof UUID ? (UUID)id : null;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    private String extractName(Object profile) {
        try {
            Object name = profile.getClass().getMethod("getName", new Class[0]).invoke(profile, new Object[0]);
            return name instanceof String ? (String)name : null;
        }
        catch (ReflectiveOperationException ignored) {
            return null;
        }
    }

    public void invalidate(UUID uuid) {
        this.cache.remove(uuid);
    }

    public void clear() {
        this.cache.clear();
    }

    private User loadUser(UUID uuid) {
        if (this.luckPerms == null) {
            return null;
        }
        User user = this.luckPerms.getUserManager().getUser(uuid);
        if (user != null) {
            return user;
        }
        try {
            return (User)this.luckPerms.getUserManager().loadUser(uuid).join();
        }
        catch (Exception ex) {
            Log.warn("Failed to load LuckPerms data for {}: {}", uuid, ex.getMessage());
            return null;
        }
    }
}

