/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.metrics;

public final class ServerTpsTracker {
    private static final int SAMPLE_SIZE = 100;
    private final long[] samples = new long[100];
    private int cursor = 0;
    private boolean warmedUp = false;

    public void recordTick(long nanoTime) {
        this.samples[this.cursor++ % 100] = nanoTime;
        if (this.cursor >= 100) {
            this.warmedUp = true;
        }
    }

    public double currentTps() {
        if (!this.warmedUp) {
            return 20.0;
        }
        int target = (this.cursor - 1 + 100) % 100;
        long elapsed = System.nanoTime() - this.samples[target];
        if (elapsed <= 0L) {
            return 20.0;
        }
        return 1.0E11 / (double)elapsed;
    }

    public void reset() {
        this.cursor = 0;
        this.warmedUp = false;
    }
}

