/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.logic;

import com.sheath.veinminer.concurrent.TaskExecutor;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.logic.rules.RuleIndex;
import com.sheath.veinminer.metrics.ServerTpsTracker;
import com.sheath.veinminer.mixin.ExperienceDroppingBlockAccessor;
import com.sheath.veinminer.permission.PermissionService;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.state.CooldownTracker;
import com.sheath.veinminer.state.KeyStateRegistry;
import com.sheath.veinminer.util.Translations;
import com.sheath.veinminer.visual.ParticleOutlineManager;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2431;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_5321;
import net.minecraft.class_6017;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;

public final class VeinMinerController {
    private static final class_2338[] NEIGHBOR_OFFSETS = VeinMinerController.buildNeighborOffsets();
    private final ConfigService configService;
    private final TaskExecutor taskExecutor;
    private final PlayerSettingsStore playerSettings;
    private final ServerTpsTracker tpsTracker;
    private final PermissionService permissionService;
    private final KeyStateRegistry keyStates;
    private final CooldownTracker cooldowns;
    private ConfigService.ConfigSnapshot snapshot;
    private RuleIndex ruleIndex;
    private long autosaveCounter = 0L;

    public VeinMinerController(ConfigService configService, TaskExecutor taskExecutor, PlayerSettingsStore playerSettings, ServerTpsTracker tpsTracker, PermissionService permissionService, KeyStateRegistry keyStates, CooldownTracker cooldowns) {
        this.configService = configService;
        this.taskExecutor = taskExecutor;
        this.playerSettings = playerSettings;
        this.tpsTracker = tpsTracker;
        this.permissionService = permissionService;
        this.keyStates = keyStates;
        this.cooldowns = cooldowns;
    }

    public void reloadFromConfig() {
        this.snapshot = this.configService.snapshot();
        this.ruleIndex = RuleIndex.fromSnapshot(this.snapshot);
        this.taskExecutor.configure(this.snapshot.general().threadCount());
        this.permissionService.configure(this.snapshot.general().autoLuckPerms());
    }

    public void onServerStarted() {
        ParticleOutlineManager.register();
        this.reloadFromConfig();
        this.autosaveCounter = 0L;
    }

    public void onServerStopping() {
        this.playerSettings.saveBlocking();
        this.cooldowns.clearAll();
        this.taskExecutor.shutdown();
    }

    public void onServerTick(MinecraftServer server) {
        this.tpsTracker.recordTick(System.nanoTime());
        ++this.autosaveCounter;
        if (this.autosaveCounter >= 6000L) {
            this.autosaveCounter = 0L;
            this.playerSettings.saveAsync();
        }
    }

    public void onPlayerDisconnect(class_3222 player) {
        this.keyStates.unregister(player);
        this.cooldowns.clear(player);
        this.playerSettings.drop(player);
    }

    public boolean handleBlockBreak(class_3218 world, class_3222 player, class_2338 pos, class_2680 state) {
        int remaining;
        if (this.snapshot == null || this.ruleIndex == null) {
            return true;
        }
        if (!this.snapshot.general().veinminerEnabled()) {
            return true;
        }
        if (!this.permissionService.hasPermission(player, "veinminer.use")) {
            this.notify(player, PlayerSettingsStore.MessageType.PERMISSION, "message.veinminer.no_permission", false, new Object[0]);
            return true;
        }
        if (!this.playerSettings.isVeinminerEnabled(player)) {
            this.notify(player, PlayerSettingsStore.MessageType.DISABLED, "message.veinminer.disabled", true, new Object[0]);
            return true;
        }
        if (!this.wantsVeinminer(player)) {
            return true;
        }
        class_1799 tool = player.method_6047();
        if (!this.ruleIndex.isToolAllowed(tool)) {
            return true;
        }
        if (!player.method_7305(state) && state.method_29291() && !this.allowsIncorrectTool(state)) {
            return true;
        }
        if (!this.ruleIndex.isBlockAllowed(state, tool)) {
            return true;
        }
        if (this.snapshot.general().cooldown().enabled() && this.cooldowns.isOnCooldown(player, this.snapshot.general().cooldown().seconds())) {
            this.notify(player, PlayerSettingsStore.MessageType.COOLDOWN, "message.veinminer.cooldown", false, new Object[0]);
            return false;
        }
        int reserve = this.snapshot.general().durabilityReserveFor(tool.method_7936());
        int n = remaining = tool.method_7963() ? tool.method_7936() - tool.method_7919() : Integer.MAX_VALUE;
        if (this.snapshot.general().checkToolDurability() && tool.method_7963() && remaining <= reserve) {
            this.notify(player, PlayerSettingsStore.MessageType.DURABILITY, "message.veinminer.low_durability", true, new Object[0]);
            return true;
        }
        int blockCap = this.computeBlockCap(tool, remaining, reserve);
        if (blockCap <= 0) {
            return true;
        }
        int silkLevel = this.resolveSilkLevel(world, tool);
        class_1799 toolCopy = tool.method_7972();
        class_2680 originState = state;
        CompletableFuture<VeinPlan> future = this.taskExecutor.submitAsync(() -> this.findVein(world, pos, originState, blockCap, silkLevel, toolCopy));
        future.thenAccept(plan -> world.method_8503().execute(() -> this.applyPlan(world, player, tool, (VeinPlan)plan, reserve)));
        return false;
    }

    private boolean wantsVeinminer(class_3222 player) {
        boolean preferKey;
        boolean bl = preferKey = this.playerSettings.useKeybind(player) && this.keyStates.hasClient(player);
        if (preferKey) {
            if (this.playerSettings.keyToggleMode(player)) {
                return this.playerSettings.isKeyToggleActive(player);
            }
            return this.keyStates.isKeyPressed(player);
        }
        this.playerSettings.resetKeyToggleState(player);
        if (this.snapshot.general().requireCrouch()) {
            return this.playerSettings.updateCrouchToggleState(player, player.method_5715());
        }
        this.playerSettings.resetCrouchToggleState(player);
        return true;
    }

    private int computeBlockCap(class_1799 tool, int remaining, int reserve) {
        int baseLimit;
        GeneralConfig.BlockLimitSettings limits = this.snapshot.general().blockLimits();
        if (limits.dynamicMaxBlocks()) {
            double tps = this.tpsTracker.currentTps();
            int range = limits.maxDynamicBlocks() - limits.minBlocks();
            int computed = (int)Math.round(tps / 20.0 * (double)range) + limits.minBlocks();
            baseLimit = Math.max(limits.minBlocks(), Math.min(limits.maxDynamicBlocks(), computed));
        } else {
            baseLimit = limits.maxBlocks();
        }
        if (!this.snapshot.general().checkToolDurability() || !tool.method_7963()) {
            return baseLimit;
        }
        int breakable = Math.max(0, remaining - reserve);
        return Math.min(baseLimit, Math.max(1, breakable));
    }

    private VeinPlan findVein(class_3218 world, class_2338 origin, class_2680 originState, int limit, int silkLevel, class_1799 toolCopy) {
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>();
        visited.add(origin);
        queue.add(origin);
        class_2248 originBlock = originState.method_26204();
        block0: while (!queue.isEmpty() && visited.size() < limit) {
            class_2338 current = (class_2338)queue.poll();
            for (class_2338 offset : NEIGHBOR_OFFSETS) {
                class_2338 neighbor = current.method_10081((class_2382)offset);
                if (visited.contains(neighbor) || world.method_8320(neighbor).method_26204() != originBlock) continue;
                visited.add(neighbor);
                queue.add(neighbor);
                if (visited.size() >= limit) continue block0;
            }
        }
        return new VeinPlan(origin, originState, visited, silkLevel, toolCopy);
    }

    private void applyPlan(class_3218 world, class_3222 player, class_1799 actualTool, VeinPlan plan, int reserve) {
        if (plan.blocks().isEmpty()) {
            return;
        }
        boolean checkDurability = this.snapshot.general().checkToolDurability() && actualTool.method_7963();
        int remaining = actualTool.method_7963() ? actualTool.method_7936() - actualTool.method_7919() : Integer.MAX_VALUE;
        int breakable = checkDurability ? Math.max(0, remaining - reserve) : plan.blocks().size();
        int limit = Math.min(breakable, plan.blocks().size());
        if (limit <= 0) {
            this.notify(player, PlayerSettingsStore.MessageType.DURABILITY, "message.veinminer.low_durability", true, new Object[0]);
            return;
        }
        int broken = 0;
        int totalXp = 0;
        ArrayList<class_1799> collectedDrops = new ArrayList<class_1799>();
        for (class_2338 pos : plan.blocks()) {
            boolean skipSnowDrops;
            if (broken >= limit) break;
            class_2680 state = world.method_8320(pos);
            if (state.method_26215()) continue;
            if (this.playerSettings.isParticlesEnabled(player) && this.snapshot.general().particles().enabled()) {
                GeneralConfig.ParticleSettings particles = this.snapshot.general().particles();
                ParticleOutlineManager.spawnOutline(world, pos, particles.red(), particles.green(), particles.blue(), particles.durationTicks());
            }
            if (!(skipSnowDrops = this.isSnowWithoutShovel(state, plan.toolCopy()))) {
                class_2248 class_22482;
                this.mergeDrops(collectedDrops, this.collectDrops(world, pos, state, plan.toolCopy(), plan.silkLevel(), player));
                if (plan.silkLevel() == 0 && (class_22482 = state.method_26204()) instanceof class_2431) {
                    class_2431 block = (class_2431)class_22482;
                    totalXp += this.resolveExperience(block, world);
                }
            }
            world.method_8652(pos, class_2246.field_10124.method_9564(), 3);
            ++broken;
        }
        if (checkDurability && broken < plan.blocks().size()) {
            this.notify(player, PlayerSettingsStore.MessageType.DURABILITY, "message.veinminer.limit_durability", true, plan.blocks().size(), broken);
        }
        for (class_1799 drop : collectedDrops) {
            class_2248.method_9577((class_1937)world, (class_2338)plan.origin(), (class_1799)drop);
        }
        if (totalXp > 0) {
            class_1303.method_31493((class_3218)world, (class_243)class_243.method_24954((class_2382)plan.origin()), (int)totalXp);
        }
        world.method_8396(null, plan.origin(), plan.originState().method_26231().method_10595(), class_3419.field_15245, 1.0f, 1.0f);
        if (actualTool.method_7963()) {
            this.damageTool(actualTool, broken, player);
        }
        if (this.snapshot.general().cooldown().enabled() && broken > 0) {
            this.cooldowns.startCooldown(player);
        }
    }

    private int resolveSilkLevel(class_3218 world, class_1799 tool) {
        class_5321 silkLookup = class_1893.field_9099;
        return this.extractSilkLevel(silkLookup, tool);
    }

    private int extractSilkLevel(Object silkLookup, class_1799 tool) {
        Class<class_6880> entryClass = class_6880.class;
        Class<class_1887> enchantmentClass = class_1887.class;
        Class<class_1799> itemClass = class_1799.class;
        for (Method method : class_1890.class.getMethods()) {
            if (!method.getName().equals("getLevel") || method.getParameterCount() != 2) continue;
            Class<?> first = method.getParameterTypes()[0];
            Class<?> second = method.getParameterTypes()[1];
            try {
                if (entryClass.isAssignableFrom(first) && itemClass.isAssignableFrom(second) && silkLookup instanceof class_6880) {
                    class_6880 entry = (class_6880)silkLookup;
                    return (Integer)method.invoke(null, entry, tool);
                }
                if (enchantmentClass.isAssignableFrom(first) && itemClass.isAssignableFrom(second)) {
                    class_1887 enchantment = silkLookup instanceof class_6880 ? (class_1887)((class_6880)silkLookup).comp_349() : (class_1887)silkLookup;
                    return (Integer)method.invoke(null, enchantment, tool);
                }
                if (itemClass.isAssignableFrom(first) && entryClass.isAssignableFrom(second) && silkLookup instanceof class_6880) {
                    class_6880 entry = (class_6880)silkLookup;
                    return (Integer)method.invoke(null, tool, entry);
                }
                if (!itemClass.isAssignableFrom(first) || !enchantmentClass.isAssignableFrom(second)) continue;
                class_1887 enchantment = silkLookup instanceof class_6880 ? (class_1887)((class_6880)silkLookup).comp_349() : (class_1887)silkLookup;
                return (Integer)method.invoke(null, tool, enchantment);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return 0;
    }

    private List<class_1799> collectDrops(class_3218 world, class_2338 pos, class_2680 state, class_1799 tool, int silkLevel, class_3222 player) {
        class_2586 blockEntity = world.method_8321(pos);
        try {
            return class_2248.method_9609((class_2680)state, (class_3218)world, (class_2338)pos, (class_2586)blockEntity, (class_1297)player, (class_1799)tool);
        }
        catch (Exception exception) {
            try {
                return class_2248.method_9562((class_2680)state, (class_3218)world, (class_2338)pos, (class_2586)blockEntity);
            }
            catch (Exception exception2) {
                return List.of();
            }
        }
    }

    private void mergeDrops(List<class_1799> target, List<class_1799> newDrops) {
        block0: for (class_1799 drop : newDrops) {
            for (class_1799 existing : target) {
                if (!this.stacksMatch(existing, drop)) continue;
                existing.method_7933(drop.method_7947());
                continue block0;
            }
            target.add(drop.method_7972());
        }
    }

    private int resolveExperience(class_2431 block, class_3218 world) {
        class_6017 provider = ((ExperienceDroppingBlockAccessor)block).veinminer$getExperienceDropped();
        return provider.method_35008(world.field_9229);
    }

    private void notify(class_3222 player, PlayerSettingsStore.MessageType type, String translationKey, boolean actionBar, Object ... args) {
        if (!this.playerSettings.isMessageEnabled(player, type)) {
            return;
        }
        class_2561 message = Translations.translate(translationKey, args);
        player.method_7353(message, actionBar);
    }

    private void damageTool(class_1799 tool, int amount, class_3222 player) {
        try {
            Method modern = class_1799.class.getMethod("damage", Integer.TYPE, class_3222.class, class_1304.class);
            modern.invoke((Object)tool, amount, player, class_1304.field_6173);
            return;
        }
        catch (Exception modern) {
            try {
                Method legacy = class_1799.class.getMethod("damage", Integer.TYPE, Random.class, class_3222.class);
                legacy.invoke((Object)tool, amount, player.method_59922(), player);
                return;
            }
            catch (Exception legacy) {
                try {
                    Method consumerDamage = class_1799.class.getMethod("damage", Integer.TYPE, class_1309.class, Consumer.class);
                    consumerDamage.invoke((Object)tool, amount, player, living -> {});
                    return;
                }
                catch (Exception exception) {
                    tool.method_7974(tool.method_7919() + amount);
                    return;
                }
            }
        }
    }

    private boolean stacksMatch(class_1799 a, class_1799 b) {
        try {
            Method canCombine = class_1799.class.getMethod("canCombine", class_1799.class, class_1799.class);
            return (Boolean)canCombine.invoke(null, a, b);
        }
        catch (Exception canCombine) {
            try {
                Method method = class_1799.class.getMethod("areItemsAndComponentsEqual", class_1799.class, class_1799.class);
                return (Boolean)method.invoke(null, a, b);
            }
            catch (Exception method) {
                try {
                    Method method2 = class_1799.class.getMethod("areEqual", class_1799.class, class_1799.class);
                    return (Boolean)method2.invoke(null, a, b);
                }
                catch (Exception exception) {
                    return class_1799.method_7984((class_1799)a, (class_1799)b);
                }
            }
        }
    }

    private boolean allowsIncorrectTool(class_2680 state) {
        return this.isSnow(state);
    }

    private boolean isSnow(class_2680 state) {
        class_2248 block = state.method_26204();
        return block == class_2246.field_10477 || block == class_2246.field_10491;
    }

    private boolean isSnowWithoutShovel(class_2680 state, class_1799 tool) {
        return this.isSnow(state) && !this.isShovel(tool);
    }

    private boolean isShovel(class_1799 tool) {
        if (tool == null || tool.method_7960()) {
            return false;
        }
        class_1792 item = tool.method_7909();
        return item == class_1802.field_8876 || item == class_1802.field_8776 || item == class_1802.field_8699 || item == class_1802.field_8322 || item == class_1802.field_8250 || item == class_1802.field_22023;
    }

    private static class_2338[] buildNeighborOffsets() {
        class_2338[] offsets = new class_2338[26];
        int index = 0;
        for (int dx = -1; dx <= 1; ++dx) {
            for (int dy = -1; dy <= 1; ++dy) {
                for (int dz = -1; dz <= 1; ++dz) {
                    if (dx == 0 && dy == 0 && dz == 0) continue;
                    offsets[index++] = new class_2338(dx, dy, dz);
                }
            }
        }
        return offsets;
    }

    public static final class Permissions {
        public static final String USE = "veinminer.use";
        public static final String RELOAD = "veinminer.reload";

        private Permissions() {
        }
    }

    private record VeinPlan(class_2338 origin, class_2680 originState, Set<class_2338> blocks, int silkLevel, class_1799 toolCopy) {
    }
}

