/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.core;

import com.mojang.brigadier.CommandDispatcher;
import com.sheath.veinminer.command.VeinMinerCommand;
import com.sheath.veinminer.concurrent.TaskExecutor;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.logic.VeinMinerController;
import com.sheath.veinminer.metrics.ServerTpsTracker;
import com.sheath.veinminer.network.NetworkService;
import com.sheath.veinminer.permission.PermissionService;
import com.sheath.veinminer.player.PlayerSettingsStore;
import com.sheath.veinminer.state.ClearConfirmationManager;
import com.sheath.veinminer.state.CooldownTracker;
import com.sheath.veinminer.state.KeyStateRegistry;
import com.sheath.veinminer.testing.FeatureTestHarness;
import com.sheath.veinminer.util.Log;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.event.player.PlayerBlockBreakEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_2168;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public final class Bootstrap {
    private final ConfigService configService = new ConfigService();
    private final TaskExecutor taskExecutor = new TaskExecutor();
    private final PlayerSettingsStore playerSettings = new PlayerSettingsStore(this.taskExecutor);
    private final ServerTpsTracker tpsTracker = new ServerTpsTracker();
    private final PermissionService permissionService = new PermissionService();
    private final KeyStateRegistry keyStates = new KeyStateRegistry();
    private final CooldownTracker cooldowns = new CooldownTracker();
    private final NetworkService networkService = new NetworkService(this.keyStates, this.playerSettings);
    private final ClearConfirmationManager confirmations = new ClearConfirmationManager();
    private final VeinMinerController controller = new VeinMinerController(this.configService, this.taskExecutor, this.playerSettings, this.tpsTracker, this.permissionService, this.keyStates, this.cooldowns);
    private final VeinMinerCommand commandHandler = new VeinMinerCommand(this);
    private final FeatureTestHarness featureTestHarness = new FeatureTestHarness(this);
    private boolean commonSetupComplete;
    private boolean clientSetupComplete;
    private boolean eventsRegistered;

    public synchronized void onCommonSetup() {
        if (this.commonSetupComplete) {
            Log.debug("Common bootstrap already executed; skipping", new Object[0]);
            return;
        }
        Log.debug("Bootstrapping common services", new Object[0]);
        this.configService.loadAll();
        this.playerSettings.load();
        this.controller.reloadFromConfig();
        this.taskExecutor.configure(this.configService.general().threadCount());
        this.registerEvents();
        this.commonSetupComplete = true;
        Log.debug("Common bootstrap finished", new Object[0]);
    }

    public synchronized void onClientSetup() {
        if (this.clientSetupComplete) {
            Log.debug("Client bootstrap already executed; skipping", new Object[0]);
            return;
        }
        Log.debug("Bootstrapping client services", new Object[0]);
        this.clientSetupComplete = true;
    }

    public ConfigService configService() {
        return this.configService;
    }

    public TaskExecutor taskExecutor() {
        return this.taskExecutor;
    }

    public PlayerSettingsStore playerSettings() {
        return this.playerSettings;
    }

    public ServerTpsTracker tpsTracker() {
        return this.tpsTracker;
    }

    public PermissionService permissionService() {
        return this.permissionService;
    }

    public KeyStateRegistry keyStates() {
        return this.keyStates;
    }

    public ClearConfirmationManager confirmations() {
        return this.confirmations;
    }

    public VeinMinerController controller() {
        return this.controller;
    }

    public FeatureTestHarness featureTestHarness() {
        return this.featureTestHarness;
    }

    public boolean isCommonSetupComplete() {
        return this.commonSetupComplete;
    }

    public boolean isClientSetupComplete() {
        return this.clientSetupComplete;
    }

    private void registerEvents() {
        if (this.eventsRegistered) {
            return;
        }
        this.eventsRegistered = true;
        this.networkService.register();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> this.controller.onServerStarted());
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> this.controller.onServerStopping());
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            this.controller.onServerTick(server);
            this.confirmations.tick(server);
        });
        PlayerBlockBreakEvents.BEFORE.register((world, player, pos, state, blockEntity) -> {
            class_3218 serverWorld;
            block3: {
                block2: {
                    if (!(world instanceof class_3218)) break block2;
                    serverWorld = (class_3218)world;
                    if (player instanceof class_3222) break block3;
                }
                return true;
            }
            class_3222 serverPlayer = (class_3222)player;
            return this.controller.handleBlockBreak(serverWorld, serverPlayer, pos, state);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> this.controller.onPlayerDisconnect(handler.field_14140));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> this.commandHandler.register((CommandDispatcher<class_2168>)dispatcher));
    }
}

