/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.sheath.veinminer.config.TomlConfigFile;
import com.sheath.veinminer.util.Log;
import java.util.Locale;
import java.util.Objects;

public final class GeneralConfig
extends TomlConfigFile {
    private boolean veinminerEnabled = true;
    private boolean requireCrouch = true;
    private boolean checkToolDurability = true;
    private int durabilityCap = 1;
    private DurabilityMode durabilityMode = DurabilityMode.ABSOLUTE;
    private int threadCount = 4;
    private final CooldownSettings cooldown = new CooldownSettings();
    private final BlockLimitSettings blockLimits = new BlockLimitSettings();
    private final ParticleSettings particles = new ParticleSettings();
    private BlockListMode blockListMode = BlockListMode.GLOBAL_WHITELIST;
    private boolean autoLuckPerms = false;

    public GeneralConfig() {
        super("GeneralConfig.toml");
    }

    public void load() {
        try (CommentedFileConfig config = this.loadConfig();){
            boolean legacyPerTool;
            this.veinminerEnabled = (Boolean)config.getOrElse("General.veinminerEnabled", (Object)this.veinminerEnabled);
            this.requireCrouch = (Boolean)config.getOrElse("General.requireCrouch", (Object)this.requireCrouch);
            this.checkToolDurability = (Boolean)config.getOrElse("General.checkToolDurability", (Object)this.checkToolDurability);
            this.durabilityCap = (Integer)config.getOrElse("General.durabilityCap", (Object)this.durabilityCap);
            this.durabilityMode = DurabilityMode.parse((String)config.getOrElse("General.durabilityThreshold", (Object)this.durabilityMode.name()), this.durabilityMode);
            this.threadCount = Math.max(1, (Integer)config.getOrElse("General.threadCount", (Object)this.threadCount));
            this.cooldown.enabled = (Boolean)config.getOrElse("Cooldown.enabled", (Object)this.cooldown.enabled);
            this.cooldown.seconds = Math.max(0, (Integer)config.getOrElse("Cooldown.seconds", (Object)this.cooldown.seconds));
            this.blockLimits.dynamicMaxBlocks = (Boolean)config.getOrElse("BlockLimits.dynamicMaxBlocks", (Object)this.blockLimits.dynamicMaxBlocks);
            this.blockLimits.maxBlocks = Math.max(1, (Integer)config.getOrElse("BlockLimits.maxBlocks", (Object)this.blockLimits.maxBlocks));
            this.blockLimits.minBlocks = Math.max(1, (Integer)config.getOrElse("BlockLimits.minBlocks", (Object)this.blockLimits.minBlocks));
            this.blockLimits.maxDynamicBlocks = Math.max(this.blockLimits.minBlocks, (Integer)config.getOrElse("BlockLimits.maxDynamicBlocks", (Object)this.blockLimits.maxDynamicBlocks));
            this.particles.enabled = (Boolean)config.getOrElse("Particles.enabled", (Object)this.particles.enabled);
            this.particles.durationTicks = Math.max(1, (Integer)config.getOrElse("Particles.durationTicks", (Object)this.particles.durationTicks));
            this.particles.red = this.clampColor((Integer)config.getOrElse("Particles.red", (Object)this.particles.red), "Particles.red");
            this.particles.green = this.clampColor((Integer)config.getOrElse("Particles.green", (Object)this.particles.green), "Particles.green");
            this.particles.blue = this.clampColor((Integer)config.getOrElse("Particles.blue", (Object)this.particles.blue), "Particles.blue");
            this.blockListMode = config.contains("Advanced.blockListMode") ? BlockListMode.parse((String)config.get("Advanced.blockListMode"), this.blockListMode) : ((legacyPerTool = ((Boolean)config.getOrElse("Advanced.blocksPerTool", (Object)this.blockListMode.perTool())).booleanValue()) ? BlockListMode.PER_TOOL_WHITELIST : BlockListMode.GLOBAL_WHITELIST);
            this.autoLuckPerms = (Boolean)config.getOrElse("Integration.autoLuckPerms", (Object)this.autoLuckPerms);
            this.writeBack(config);
            this.save(config);
        }
    }

    public void save() {
        try (CommentedFileConfig config = this.loadConfig();){
            this.writeBack(config);
            this.save(config);
        }
    }

    private void writeBack(CommentedFileConfig config) {
        config.set("General.veinminerEnabled", (Object)this.veinminerEnabled);
        config.setComment("General.veinminerEnabled", "Enable or disable Veinminer entirely");
        config.set("General.requireCrouch", (Object)this.requireCrouch);
        config.setComment("General.requireCrouch", "Require the player to crouch (sneak) to activate Veinminer");
        config.set("General.checkToolDurability", (Object)this.checkToolDurability);
        config.setComment("General.checkToolDurability", "Prevent Veinminer from activating if the tool would break");
        config.set("General.durabilityCap", (Object)this.durabilityCap);
        config.setComment("General.durabilityCap", "Minimum durability to keep when Veinminer activates");
        config.set("General.durabilityThreshold", (Object)this.durabilityMode.name());
        config.setComment("General.durabilityThreshold", "ABSOLUTE keeps a fixed number of durability points, PERCENTAGE keeps a percentage");
        config.set("General.threadCount", (Object)this.threadCount);
        config.setComment("General.threadCount", "Number of worker threads used for asynchronous operations");
        config.set("Cooldown.enabled", (Object)this.cooldown.enabled);
        config.setComment("Cooldown.enabled", "Enable a cooldown between Veinminer uses");
        config.set("Cooldown.seconds", (Object)this.cooldown.seconds);
        config.setComment("Cooldown.seconds", "Cooldown duration in seconds");
        config.set("BlockLimits.dynamicMaxBlocks", (Object)this.blockLimits.dynamicMaxBlocks);
        config.setComment("BlockLimits.dynamicMaxBlocks", "Dynamically adjust max mined blocks based on server TPS");
        config.set("BlockLimits.maxBlocks", (Object)this.blockLimits.maxBlocks);
        config.setComment("BlockLimits.maxBlocks", "Maximum blocks mined when dynamic scaling is disabled");
        config.set("BlockLimits.minBlocks", (Object)this.blockLimits.minBlocks);
        config.setComment("BlockLimits.minBlocks", "Lower bound for dynamic scaling");
        config.set("BlockLimits.maxDynamicBlocks", (Object)this.blockLimits.maxDynamicBlocks);
        config.setComment("BlockLimits.maxDynamicBlocks", "Upper bound for dynamic scaling");
        config.set("Particles.enabled", (Object)this.particles.enabled);
        config.setComment("Particles.enabled", "Render an outline around blocks scheduled to be mined");
        config.set("Particles.durationTicks", (Object)this.particles.durationTicks);
        config.setComment("Particles.durationTicks", "Particle lifespan in ticks");
        config.set("Particles.red", (Object)this.particles.red);
        config.set("Particles.green", (Object)this.particles.green);
        config.set("Particles.blue", (Object)this.particles.blue);
        config.set("Advanced.blockListMode", (Object)this.blockListMode.name());
        config.setComment("Advanced.blockListMode", "Controls how block lists behave. Options: GLOBAL_WHITELIST, PER_TOOL_WHITELIST, GLOBAL_BLACKLIST, PER_TOOL_BLACKLIST");
        config.remove("Advanced.blocksPerTool");
        config.set("Integration.autoLuckPerms", (Object)this.autoLuckPerms);
        config.setComment("Integration.autoLuckPerms", "Attempt to hook into LuckPerms automatically if present");
    }

    private int clampColor(int value, String name) {
        if (value < 0 || value > 255) {
            int clamped = Math.max(0, Math.min(255, value));
            Log.warn("{}={} is outside the 0-255 range. Clamping to {}", name, value, clamped);
            return clamped;
        }
        return value;
    }

    public boolean veinminerEnabled() {
        return this.veinminerEnabled;
    }

    public void setVeinminerEnabled(boolean veinminerEnabled) {
        this.veinminerEnabled = veinminerEnabled;
    }

    public boolean requireCrouch() {
        return this.requireCrouch;
    }

    public void setRequireCrouch(boolean requireCrouch) {
        this.requireCrouch = requireCrouch;
    }

    public boolean checkToolDurability() {
        return this.checkToolDurability;
    }

    public void setCheckToolDurability(boolean checkToolDurability) {
        this.checkToolDurability = checkToolDurability;
    }

    public int durabilityCap() {
        return this.durabilityCap;
    }

    public void setDurabilityCap(int durabilityCap) {
        this.durabilityCap = Math.max(0, durabilityCap);
    }

    public DurabilityMode durabilityMode() {
        return this.durabilityMode;
    }

    public void setDurabilityMode(DurabilityMode durabilityMode) {
        this.durabilityMode = durabilityMode;
    }

    public int threadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = Math.max(1, threadCount);
    }

    public CooldownSettings cooldown() {
        return this.cooldown;
    }

    public BlockLimitSettings blockLimits() {
        return this.blockLimits;
    }

    public ParticleSettings particles() {
        return this.particles;
    }

    public BlockListMode blockListMode() {
        return this.blockListMode;
    }

    public void setBlockListMode(BlockListMode blockListMode) {
        this.blockListMode = Objects.requireNonNull(blockListMode, "blockListMode");
    }

    public boolean autoLuckPerms() {
        return this.autoLuckPerms;
    }

    public void setAutoLuckPerms(boolean autoLuckPerms) {
        this.autoLuckPerms = autoLuckPerms;
    }

    public int durabilityReserveFor(int maxDurability) {
        if (this.durabilityMode == DurabilityMode.PERCENTAGE) {
            double percentage = Math.max(0, Math.min(100, this.durabilityCap));
            return (int)Math.ceil(percentage / 100.0 * (double)maxDurability);
        }
        return Math.max(0, this.durabilityCap);
    }

    public static enum DurabilityMode {
        ABSOLUTE,
        PERCENTAGE;


        static DurabilityMode parse(String raw, DurabilityMode fallback) {
            try {
                return DurabilityMode.valueOf(raw.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException ex) {
                Log.warn("Unknown durability mode '{}', defaulting to {}", new Object[]{raw, fallback});
                return fallback;
            }
        }
    }

    public static final class CooldownSettings {
        private boolean enabled = false;
        private int seconds = 5;

        public boolean enabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int seconds() {
            return this.seconds;
        }

        public void setSeconds(int seconds) {
            this.seconds = Math.max(0, seconds);
        }
    }

    public static final class BlockLimitSettings {
        private boolean dynamicMaxBlocks = false;
        private int maxBlocks = 64;
        private int minBlocks = 16;
        private int maxDynamicBlocks = 64;

        public boolean dynamicMaxBlocks() {
            return this.dynamicMaxBlocks;
        }

        public void setDynamicMaxBlocks(boolean dynamicMaxBlocks) {
            this.dynamicMaxBlocks = dynamicMaxBlocks;
        }

        public int maxBlocks() {
            return this.maxBlocks;
        }

        public void setMaxBlocks(int maxBlocks) {
            this.maxBlocks = Math.max(1, maxBlocks);
        }

        public int minBlocks() {
            return this.minBlocks;
        }

        public void setMinBlocks(int minBlocks) {
            this.minBlocks = Math.max(1, minBlocks);
        }

        public int maxDynamicBlocks() {
            return this.maxDynamicBlocks;
        }

        public void setMaxDynamicBlocks(int maxDynamicBlocks) {
            this.maxDynamicBlocks = Math.max(this.minBlocks, maxDynamicBlocks);
        }
    }

    public static final class ParticleSettings {
        private boolean enabled = true;
        private int durationTicks = 60;
        private int red = 255;
        private int green = 0;
        private int blue = 0;

        public boolean enabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public int durationTicks() {
            return this.durationTicks;
        }

        public void setDurationTicks(int durationTicks) {
            this.durationTicks = Math.max(1, durationTicks);
        }

        public int red() {
            return this.red;
        }

        public void setRed(int red) {
            this.red = Math.max(0, Math.min(255, red));
        }

        public int green() {
            return this.green;
        }

        public void setGreen(int green) {
            this.green = Math.max(0, Math.min(255, green));
        }

        public int blue() {
            return this.blue;
        }

        public void setBlue(int blue) {
            this.blue = Math.max(0, Math.min(255, blue));
        }
    }

    public static enum BlockListMode {
        GLOBAL_WHITELIST(false, false),
        PER_TOOL_WHITELIST(true, false),
        GLOBAL_BLACKLIST(false, true),
        PER_TOOL_BLACKLIST(true, true);

        private final boolean perTool;
        private final boolean blacklist;

        private BlockListMode(boolean perTool, boolean blacklist) {
            this.perTool = perTool;
            this.blacklist = blacklist;
        }

        public boolean perTool() {
            return this.perTool;
        }

        public boolean blacklist() {
            return this.blacklist;
        }

        public boolean whitelist() {
            return !this.blacklist;
        }

        public static BlockListMode parse(String raw, BlockListMode fallback) {
            if (raw == null) {
                return fallback;
            }
            String normalized = raw.trim().toUpperCase(Locale.ROOT).replace('-', '_').replace(' ', '_');
            try {
                return BlockListMode.valueOf(normalized);
            }
            catch (IllegalArgumentException ex) {
                Log.warn("Unknown block list mode '{}', defaulting to {}", new Object[]{raw, fallback});
                return fallback;
            }
        }
    }
}

