/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.sheath.veinminer.config.ConfigFileFormatter;
import com.sheath.veinminer.config.TomlConfigFile;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;

public final class BlocksPerToolConfig
extends TomlConfigFile {
    private final NavigableMap<String, NavigableSet<String>> allowed = new TreeMap<String, NavigableSet<String>>();

    public BlocksPerToolConfig() {
        super("BlockPerToolList.toml");
    }

    public void load(Map<String, ? extends Collection<String>> defaults) {
        this.allowed.clear();
        try (CommentedFileConfig config = this.loadConfig();){
            if (config.isEmpty()) {
                defaults.forEach((key, values) -> this.allowed.put((String)key, new TreeSet(values)));
            } else {
                for (String key2 : config.valueMap().keySet()) {
                    Object raw = config.get(key2);
                    TreeSet<String> values2 = new TreeSet<String>();
                    if (raw instanceof Iterable) {
                        Iterable iterable = (Iterable)raw;
                        for (Object element : iterable) {
                            if (element == null) continue;
                            values2.add(element.toString().trim());
                        }
                    } else if (raw != null) {
                        values2.add(raw.toString().trim());
                    }
                    this.allowed.put(key2, values2);
                }
            }
            this.writeBack(config);
            this.save(config);
        }
        ConfigFileFormatter.formatArraysOnePerLine(this.path());
    }

    public void save() {
        try (CommentedFileConfig config = this.loadConfig();){
            this.writeBack(config);
            this.save(config);
        }
        ConfigFileFormatter.formatArraysOnePerLine(this.path());
    }

    private void writeBack(CommentedFileConfig config) {
        config.clear();
        config.setComment("", "Mapping of tool registry ids or tag strings to block list entries (ids or '#tag').\nUse 'hand' to target empty-hand veinmining.\nActs as a whitelist or blacklist depending on Advanced.blockListMode.\nExample:\n  \"minecraft:iron_pickaxe\" = [\"minecraft:diamond_ore\", \"#forge:ores\"]");
        for (Map.Entry entry : this.allowed.entrySet()) {
            config.set((String)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
    }

    public NavigableMap<String, NavigableSet<String>> values() {
        return Collections.unmodifiableNavigableMap(this.allowed);
    }

    public NavigableSet<String> getOrCreate(String toolKey) {
        return this.allowed.computeIfAbsent(toolKey, key -> new TreeSet());
    }

    public boolean containsTool(String toolKey) {
        return this.allowed.containsKey(toolKey);
    }

    public NavigableSet<String> get(String toolKey) {
        return (NavigableSet)this.allowed.get(toolKey);
    }

    public void replaceAll(Map<String, ? extends Collection<String>> replacements) {
        this.allowed.clear();
        replacements.forEach((key, values) -> this.allowed.put((String)key, new TreeSet(values)));
    }

    public boolean removeTool(String toolKey) {
        return this.allowed.remove(toolKey) != null;
    }

    public boolean clearAll() {
        if (this.allowed.isEmpty()) {
            return false;
        }
        this.allowed.clear();
        return true;
    }

    public boolean clearBlocksFor(String toolKey) {
        NavigableSet values = (NavigableSet)this.allowed.get(toolKey);
        if (values == null || values.isEmpty()) {
            return false;
        }
        values.clear();
        return true;
    }
}

