/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.config;

import com.electronwill.nightconfig.core.file.CommentedFileConfig;
import com.sheath.veinminer.config.ConfigFileFormatter;
import com.sheath.veinminer.config.TomlConfigFile;
import com.sheath.veinminer.util.Log;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.regex.Pattern;

public final class AllowedBlocksConfig
extends TomlConfigFile {
    private static final Pattern ID_PATTERN = Pattern.compile("^#?[a-z0-9_.-]+:[a-z0-9_/.-]+$");
    private final NavigableSet<String> allowedBlocks = new TreeSet<String>();

    public AllowedBlocksConfig() {
        super("BlocksList.toml");
    }

    public void load(Collection<String> defaults) {
        this.allowedBlocks.clear();
        try (CommentedFileConfig config = this.loadConfig();){
            List raw = (List)config.getOrElse("blocks", new ArrayList<String>(defaults));
            for (String entry : raw) {
                String trimmed;
                if (entry == null || (trimmed = entry.trim()).isEmpty()) continue;
                if (!ID_PATTERN.matcher(trimmed).matches()) {
                    Log.warn("Ignoring malformed block entry '{}'", trimmed);
                    continue;
                }
                this.allowedBlocks.add(trimmed);
            }
            if (this.allowedBlocks.isEmpty()) {
                this.allowedBlocks.addAll(defaults);
            }
            this.writeBack(config);
            this.save(config);
        }
        ConfigFileFormatter.formatArraysOnePerLine(this.path());
    }

    public void save() {
        try (CommentedFileConfig config = this.loadConfig();){
            this.writeBack(config);
            this.save(config);
        }
        ConfigFileFormatter.formatArraysOnePerLine(this.path());
    }

    private void writeBack(CommentedFileConfig config) {
        config.set("blocks", new ArrayList<String>(this.allowedBlocks));
        config.setComment("blocks", "Block list entries by registry id or tag (prefix with '#' for tags). Mode controlled by Advanced.blockListMode");
    }

    public NavigableSet<String> values() {
        return Collections.unmodifiableNavigableSet(this.allowedBlocks);
    }

    public void replaceValues(Collection<String> newValues) {
        this.allowedBlocks.clear();
        this.allowedBlocks.addAll(newValues);
    }

    public boolean addValue(String value) {
        return this.allowedBlocks.add(value);
    }

    public boolean removeValue(String value) {
        return this.allowedBlocks.remove(value);
    }

    public boolean clear() {
        if (this.allowedBlocks.isEmpty()) {
            return false;
        }
        this.allowedBlocks.clear();
        return true;
    }
}

