/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.state.ClearConfirmationManager;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.util.Translations;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

final class ToolsCommand {
    private ToolsCommand() {
    }

    static ArgumentBuilder<class_2168, ?> build(Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tools").requires(managePermission::test)).then(class_2170.method_9247((String)"help").executes(ctx -> ToolsCommand.showHelp((class_2168)ctx.getSource())))).executes(ctx -> ToolsCommand.list((class_2168)ctx.getSource(), bootstrap))).then(class_2170.method_9247((String)"list").executes(ctx -> ToolsCommand.list((class_2168)ctx.getSource(), bootstrap)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(ToolsCommand.suggestAllTools()).executes(ctx -> ToolsCommand.add((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(ToolsCommand.suggestConfiguredTools(bootstrap)).executes(ctx -> ToolsCommand.remove((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(managePermission::test)).executes(ctx -> ToolsCommand.requestClear((class_2168)ctx.getSource(), bootstrap, managePermission, confirmations)));
    }

    private static int list(class_2168 source, Bootstrap bootstrap) {
        ConfigService.ConfigSnapshot snapshot = bootstrap.configService().snapshot();
        List<String> entries = List.copyOf(snapshot.allowedTools().raw());
        if (entries.isEmpty()) {
            source.method_9226(() -> Translations.translate("command.veinminer.tools.none", new Object[0]), false);
            return 1;
        }
        source.method_9226(() -> Translations.translate("command.veinminer.tools.header", new Object[0]), false);
        entries.forEach(entry -> source.method_9226(() -> Translations.translate("command.veinminer.list_entry", entry), false));
        return 1;
    }

    private static int add(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String rawEntry) {
        if (!ToolsCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().addAllowedTool(rawEntry);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.tools.added", rawEntry), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT -> {
                source.method_9213(Translations.translate("command.veinminer.tools.exists", rawEntry));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID -> {
                source.method_9213(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
            default -> {
                Log.warn("Unexpected change result {} when adding tool {}", new Object[]{result, rawEntry});
                source.method_9213(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
        };
    }

    private static int requestClear(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations) {
        if (!ToolsCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        confirmations.request(source, confirmSource -> {
            ConfigService.ChangeResult result = bootstrap.configService().clearAllowedTools();
            if (result == ConfigService.ChangeResult.SUCCESS) {
                bootstrap.controller().reloadFromConfig();
                confirmSource.method_9226(() -> Translations.translate("command.veinminer.tools.cleared", new Object[0]), true);
            } else {
                confirmSource.method_9213(Translations.translate("command.veinminer.tools.none", new Object[0]));
            }
        });
        return 1;
    }

    private static int remove(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String rawEntry) {
        if (!ToolsCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().removeAllowedTool(rawEntry);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.tools.removed", rawEntry), true);
                yield 1;
            }
            case ConfigService.ChangeResult.NOT_FOUND -> {
                source.method_9213(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID -> {
                source.method_9213(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
            default -> {
                Log.warn("Unexpected change result {} when removing tool {}", new Object[]{result, rawEntry});
                source.method_9213(Translations.translate("command.veinminer.tools.not_found", rawEntry));
                yield 0;
            }
        };
    }

    private static SuggestionProvider<class_2168> suggestAllTools() {
        return (ctx, builder) -> class_2172.method_9265(ToolsCommand.collectToolSuggestions(), (SuggestionsBuilder)builder);
    }

    private static SuggestionProvider<class_2168> suggestConfiguredTools(Bootstrap bootstrap) {
        return (ctx, builder) -> {
            ArrayList<String> options = new ArrayList<String>(bootstrap.configService().snapshot().allowedTools().raw());
            if (options.isEmpty()) {
                return builder.buildFuture();
            }
            return class_2172.method_9265(options, (SuggestionsBuilder)builder);
        };
    }

    private static List<String> collectToolSuggestions() {
        ArrayList<String> options = new ArrayList<String>(class_7923.field_41178.method_10235().size() + 1);
        class_7923.field_41178.method_10235().forEach(id -> options.add(id.toString()));
        class_7923.field_41178.method_40272().forEach(tag -> {
            String tagId = ToolsCommand.tagId(tag);
            if (tagId != null) {
                options.add("#" + tagId);
            }
        });
        options.add("hand");
        return options;
    }

    private static boolean ensurePermission(class_2168 source, Predicate<class_2168> managePermission) {
        if (managePermission.test(source)) {
            return true;
        }
        source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
        return false;
    }

    private static String tagId(Object tag) {
        Object value;
        if (tag instanceof class_6862) {
            class_6862 tagKey = (class_6862)tag;
            return tagKey.comp_327().toString();
        }
        try {
            Method id = tag.getClass().getMethod("id", new Class[0]);
            value = id.invoke(tag, new Object[0]);
            if (value != null) {
                return value.toString();
            }
        }
        catch (Exception id) {
            // empty catch block
        }
        try {
            Method getTag = tag.getClass().getMethod("getTag", new Class[0]);
            value = getTag.invoke(tag, new Object[0]);
            if (value instanceof class_6862) {
                class_6862 tagKey = (class_6862)value;
                return tagKey.comp_327().toString();
            }
        }
        catch (Exception getTag) {
            // empty catch block
        }
        try {
            Method getTagKey = tag.getClass().getMethod("getTagKey", new Class[0]);
            value = getTagKey.invoke(tag, new Object[0]);
            if (value instanceof class_6862) {
                class_6862 tagKey = (class_6862)value;
                return tagKey.comp_327().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static int showHelp(class_2168 source) {
        source.method_9226(() -> Translations.translate("command.veinminer.help.tools", new Object[0]), false);
        return 1;
    }
}

