/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.util.Translations;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

final class ParticlesCommand {
    private ParticlesCommand() {
    }

    static ArgumentBuilder<class_2168, ?> build(Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"particles").requires(managePermission::test)).then(class_2170.method_9247((String)"help").executes(ctx -> ParticlesCommand.showHelp((class_2168)ctx.getSource())))).executes(ctx -> ParticlesCommand.showHelp((class_2168)ctx.getSource()))).then(class_2170.method_9247((String)"toggle").executes(ctx -> ParticlesCommand.toggleParticles((class_2168)ctx.getSource(), bootstrap, managePermission)))).then(class_2170.method_9247((String)"setcolor").then(class_2170.method_9244((String)"red", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(class_2170.method_9244((String)"green", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).then(class_2170.method_9244((String)"blue", (ArgumentType)IntegerArgumentType.integer((int)0, (int)255)).executes(ctx -> ParticlesCommand.setColor((class_2168)ctx.getSource(), bootstrap, managePermission, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"red"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"green"), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"blue")))))))).then(class_2170.method_9247((String)"setduration").then(class_2170.method_9244((String)"ticks", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(ctx -> ParticlesCommand.setDuration((class_2168)ctx.getSource(), bootstrap, managePermission, IntegerArgumentType.getInteger((CommandContext)ctx, (String)"ticks")))));
    }

    private static int toggleParticles(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        GeneralConfig.ParticleSettings particles = bootstrap.configService().general().particles();
        boolean newState = !particles.enabled();
        particles.setEnabled(newState);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.particles.toggle", Translations.translate(newState ? "command.veinminer.enabled" : "command.veinminer.disabled", new Object[0])), true);
        return 1;
    }

    private static int setColor(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, int red, int green, int blue) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        GeneralConfig.ParticleSettings particles = bootstrap.configService().general().particles();
        particles.setRed(red);
        particles.setGreen(green);
        particles.setBlue(blue);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.particles.color_set", new Object[0]), true);
        return 1;
    }

    private static int setDuration(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, int ticks) {
        if (!managePermission.test(source)) {
            source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
            return 0;
        }
        bootstrap.configService().general().particles().setDurationTicks(ticks);
        bootstrap.configService().general().save();
        bootstrap.configService().rebuildSnapshot();
        bootstrap.controller().reloadFromConfig();
        source.method_9226(() -> Translations.translate("command.veinminer.particles.duration_set", ticks), true);
        return 1;
    }

    private static int showHelp(class_2168 source) {
        source.method_9226(() -> Translations.translate("command.veinminer.help.particles", new Object[0]), false);
        return 1;
    }
}

