/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.state.ClearConfirmationManager;
import com.sheath.veinminer.util.Log;
import com.sheath.veinminer.util.Translations;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

final class BlocksCommand {
    private BlocksCommand() {
    }

    static ArgumentBuilder<class_2168, ?> build(Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blocks").requires(managePermission::test)).then(class_2170.method_9247((String)"help").executes(ctx -> BlocksCommand.showHelp((class_2168)ctx.getSource())))).executes(ctx -> BlocksCommand.list((class_2168)ctx.getSource(), bootstrap))).then(class_2170.method_9247((String)"list").executes(ctx -> BlocksCommand.list((class_2168)ctx.getSource(), bootstrap)))).then(class_2170.method_9247((String)"add").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(BlocksCommand.suggestRegistryBlocks()).executes(ctx -> BlocksCommand.add((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(class_2170.method_9247((String)"remove").then(class_2170.method_9244((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(BlocksCommand.suggestConfiguredBlocks(bootstrap)).executes(ctx -> BlocksCommand.remove((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"id")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(managePermission::test)).executes(ctx -> BlocksCommand.requestClear((class_2168)ctx.getSource(), bootstrap, managePermission, confirmations)));
    }

    private static SuggestionProvider<class_2168> suggestRegistryBlocks() {
        return (ctx, builder) -> BlocksCommand.suggestBlocksAndTags(builder);
    }

    private static SuggestionProvider<class_2168> suggestConfiguredBlocks(Bootstrap bootstrap) {
        return (ctx, builder) -> {
            ArrayList<String> suggestions = new ArrayList<String>(bootstrap.configService().snapshot().allowedBlocks().raw());
            if (suggestions.isEmpty()) {
                return builder.buildFuture();
            }
            return class_2172.method_9265(suggestions, (SuggestionsBuilder)builder);
        };
    }

    private static int requestClear(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations) {
        if (!BlocksCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 descriptor = BlocksCommand.describeGlobalList(mode);
        confirmations.request(source, confirmSource -> {
            ConfigService.ChangeResult result = bootstrap.configService().clearAllowedBlocks();
            if (result == ConfigService.ChangeResult.SUCCESS) {
                bootstrap.controller().reloadFromConfig();
                confirmSource.method_9226(() -> Translations.translate("command.veinminer.blocks.cleared", descriptor), true);
            } else {
                confirmSource.method_9213(Translations.translate("command.veinminer.blocks.none", descriptor));
            }
        });
        return 1;
    }

    private static CompletableFuture<Suggestions> suggestBlocksAndTags(SuggestionsBuilder builder) {
        ArrayList<String> suggestions = new ArrayList<String>(class_7923.field_41175.method_10235().size());
        for (class_2960 id : class_7923.field_41175.method_10235()) {
            suggestions.add(id.toString());
        }
        class_7923.field_41175.method_40272().forEach(tag -> {
            String tagId = BlocksCommand.tagId(tag);
            if (tagId != null) {
                suggestions.add("#" + tagId);
            }
        });
        return class_2172.method_9265(suggestions, (SuggestionsBuilder)builder);
    }

    private static int list(class_2168 source, Bootstrap bootstrap) {
        ConfigService.ConfigSnapshot snapshot = bootstrap.configService().snapshot();
        List<String> entries = List.copyOf(snapshot.allowedBlocks().raw());
        GeneralConfig.BlockListMode mode = snapshot.general().blockListMode();
        class_2561 descriptor = BlocksCommand.describeGlobalList(mode);
        if (entries.isEmpty()) {
            source.method_9226(() -> Translations.translate("command.veinminer.blocks.none", descriptor), false);
            if (mode.perTool()) {
                source.method_9226(() -> Translations.translate("command.veinminer.blocks.per_tool_hint", new Object[0]), false);
            }
            return 1;
        }
        source.method_9226(() -> Translations.translate("command.veinminer.blocks.header", descriptor), false);
        if (mode.perTool()) {
            source.method_9226(() -> Translations.translate("command.veinminer.blocks.per_tool_hint", new Object[0]), false);
        }
        entries.forEach(entry -> source.method_9226(() -> Translations.translate("command.veinminer.list_entry", entry), false));
        return 1;
    }

    private static int add(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String rawEntry) {
        if (!BlocksCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        ConfigService.ChangeResult result = bootstrap.configService().addAllowedBlock(rawEntry);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blocks.added", rawEntry, BlocksCommand.describeGlobalList(mode)), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT -> {
                source.method_9213(Translations.translate("command.veinminer.blocks.exists", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID -> {
                source.method_9213(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
            default -> {
                Log.warn("Unexpected change result {} when adding block {}", new Object[]{result, rawEntry});
                source.method_9213(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
        };
    }

    private static int remove(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String rawEntry) {
        if (!BlocksCommand.ensurePermission(source, managePermission)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        ConfigService.ChangeResult result = bootstrap.configService().removeAllowedBlock(rawEntry);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blocks.removed", rawEntry, BlocksCommand.describeGlobalList(mode)), true);
                yield 1;
            }
            case ConfigService.ChangeResult.NOT_FOUND -> {
                source.method_9213(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID -> {
                source.method_9213(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
            default -> {
                Log.warn("Unexpected change result {} when removing block {}", new Object[]{result, rawEntry});
                source.method_9213(Translations.translate("command.veinminer.blocks.not_found", rawEntry, BlocksCommand.describeGlobalList(mode)));
                yield 0;
            }
        };
    }

    private static boolean ensurePermission(class_2168 source, Predicate<class_2168> managePermission) {
        if (managePermission.test(source)) {
            return true;
        }
        source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
        return false;
    }

    private static class_2561 describeGlobalList(GeneralConfig.BlockListMode mode) {
        String key = mode.blacklist() ? "command.veinminer.block_list_type.global_blacklist" : "command.veinminer.block_list_type.global_whitelist";
        return Translations.translate(key, new Object[0]);
    }

    private static String tagId(Object tag) {
        Object value;
        if (tag instanceof class_6862) {
            class_6862 tagKey = (class_6862)tag;
            return tagKey.comp_327().toString();
        }
        try {
            Method id = tag.getClass().getMethod("id", new Class[0]);
            value = id.invoke(tag, new Object[0]);
            if (value != null) {
                return value.toString();
            }
        }
        catch (Exception id) {
            // empty catch block
        }
        try {
            Method getTag = tag.getClass().getMethod("getTag", new Class[0]);
            value = getTag.invoke(tag, new Object[0]);
            if (value instanceof class_6862) {
                class_6862 tagKey = (class_6862)value;
                return tagKey.comp_327().toString();
            }
        }
        catch (Exception getTag) {
            // empty catch block
        }
        try {
            Method getTagKey = tag.getClass().getMethod("getTagKey", new Class[0]);
            value = getTagKey.invoke(tag, new Object[0]);
            if (value instanceof class_6862) {
                class_6862 tagKey = (class_6862)value;
                return tagKey.comp_327().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static int showHelp(class_2168 source) {
        source.method_9226(() -> Translations.translate("command.veinminer.help.blocks", new Object[0]), false);
        return 1;
    }
}

