/*
 * Decompiled with CFR 0.152.
 */
package com.sheath.veinminer.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.sheath.veinminer.config.ConfigService;
import com.sheath.veinminer.config.GeneralConfig;
import com.sheath.veinminer.core.Bootstrap;
import com.sheath.veinminer.state.ClearConfirmationManager;
import com.sheath.veinminer.util.Translations;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_6862;
import net.minecraft.class_7923;

final class BlockPerToolCommand {
    private BlockPerToolCommand() {
    }

    static ArgumentBuilder<class_2168, ?> build(Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"blockpertool").requires(managePermission::test)).then(class_2170.method_9247((String)"help").executes(ctx -> BlockPerToolCommand.showHelp((class_2168)ctx.getSource())))).then(BlockPerToolCommand.buildBlocksNode(bootstrap, managePermission, confirmations))).then(BlockPerToolCommand.buildToolNode(bootstrap, managePermission, confirmations));
    }

    private static ArgumentBuilder<class_2168, ?> buildBlocksNode(Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations) {
        return class_2170.method_9247((String)"blocks").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.word()).suggests(BlockPerToolCommand.suggestConfiguredTools(bootstrap)).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(managePermission::test)).then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests(BlockPerToolCommand.suggestAllBlocksOrTags()).executes(ctx -> BlockPerToolCommand.addBlock((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool"), StringArgumentType.getString((CommandContext)ctx, (String)"block")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(managePermission::test)).then(class_2170.method_9244((String)"block", (ArgumentType)StringArgumentType.greedyString()).suggests(BlockPerToolCommand.suggestBlocksForTool(bootstrap)).executes(ctx -> BlockPerToolCommand.removeBlock((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool"), StringArgumentType.getString((CommandContext)ctx, (String)"block")))))).then(class_2170.method_9247((String)"list").executes(ctx -> BlockPerToolCommand.listBlocks((class_2168)ctx.getSource(), bootstrap, StringArgumentType.getString((CommandContext)ctx, (String)"tool"))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(managePermission::test)).executes(ctx -> BlockPerToolCommand.requestClearBlocks((class_2168)ctx.getSource(), bootstrap, managePermission, confirmations, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))));
    }

    private static ArgumentBuilder<class_2168, ?> buildToolNode(Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations) {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tool").then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(managePermission::test)).then(class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).suggests(BlockPerToolCommand.suggestAllTools()).executes(ctx -> BlockPerToolCommand.addTool((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(managePermission::test)).then(class_2170.method_9244((String)"tool", (ArgumentType)StringArgumentType.greedyString()).suggests(BlockPerToolCommand.suggestConfiguredTools(bootstrap)).executes(ctx -> BlockPerToolCommand.removeTool((class_2168)ctx.getSource(), bootstrap, managePermission, StringArgumentType.getString((CommandContext)ctx, (String)"tool")))))).then(class_2170.method_9247((String)"list").executes(ctx -> BlockPerToolCommand.listTools((class_2168)ctx.getSource(), bootstrap)))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"clear").requires(managePermission::test)).executes(ctx -> BlockPerToolCommand.requestClearAllTools((class_2168)ctx.getSource(), bootstrap, managePermission, confirmations)));
    }

    private static int addBlock(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String tool, String block) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        ConfigService.ChangeResult result = bootstrap.configService().addBlocksPerToolBlock(tool, block);
        return switch (result) {
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.block_added", block, listDescriptor, tool), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT -> {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.block_exists", block, listDescriptor));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID, ConfigService.ChangeResult.NOT_FOUND -> {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                yield 0;
            }
            default -> {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                yield 0;
            }
        };
    }

    private static int requestClearBlocks(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations, String tool) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        NavigableSet<String> blocks = bootstrap.configService().getBlocksForTool(tool);
        if (blocks == null) {
            source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 descriptor = BlockPerToolCommand.describePerToolList(mode);
        confirmations.request(source, confirmSource -> {
            ConfigService.ChangeResult result = bootstrap.configService().clearBlocksForTool(tool);
            if (result == ConfigService.ChangeResult.SUCCESS) {
                bootstrap.controller().reloadFromConfig();
                confirmSource.method_9226(() -> Translations.translate("command.veinminer.blockpertool.blocks_cleared", descriptor, tool), true);
            } else {
                confirmSource.method_9213(Translations.translate("command.veinminer.blockpertool.no_blocks", descriptor, tool));
            }
        });
        return 1;
    }

    private static int requestClearAllTools(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, ClearConfirmationManager confirmations) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 descriptor = BlockPerToolCommand.describePerToolList(mode);
        confirmations.request(source, confirmSource -> {
            ConfigService.ChangeResult result = bootstrap.configService().clearBlocksPerTool();
            if (result == ConfigService.ChangeResult.SUCCESS) {
                bootstrap.controller().reloadFromConfig();
                confirmSource.method_9226(() -> Translations.translate("command.veinminer.blockpertool.tools_cleared", descriptor), true);
            } else {
                confirmSource.method_9213(Translations.translate("command.veinminer.blockpertool.no_tools", new Object[0]));
            }
        });
        return 1;
    }

    private static int removeBlock(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String tool, String block) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        ConfigService.ChangeResult result = bootstrap.configService().removeBlocksPerToolBlock(tool, block);
        return switch (result) {
            default -> throw new MatchException(null, null);
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.block_removed", block, listDescriptor, tool), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT, ConfigService.ChangeResult.INVALID, ConfigService.ChangeResult.NOT_FOUND -> {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.block_not_found", block, listDescriptor, tool));
                yield 0;
            }
        };
    }

    private static int listBlocks(class_2168 source, Bootstrap bootstrap, String tool) {
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        GeneralConfig.BlockListMode mode = bootstrap.configService().general().blockListMode();
        class_2561 listDescriptor = BlockPerToolCommand.describePerToolList(mode);
        NavigableSet<String> blocks = bootstrap.configService().getBlocksForTool(tool);
        if (blocks == null || blocks.isEmpty()) {
            source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.no_blocks", listDescriptor, tool), false);
        } else {
            source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.blocks_for_tool", listDescriptor, tool), false);
            blocks.forEach(block -> source.method_9226(() -> Translations.translate("command.veinminer.list_entry", block), false));
        }
        return 1;
    }

    private static int addTool(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String tool) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().addBlocksPerToolTool(tool);
        return switch (result) {
            default -> throw new MatchException(null, null);
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.tool_added", tool), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT -> {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_exists", tool));
                yield 0;
            }
            case ConfigService.ChangeResult.INVALID, ConfigService.ChangeResult.NOT_FOUND -> {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
                yield 0;
            }
        };
    }

    private static int removeTool(class_2168 source, Bootstrap bootstrap, Predicate<class_2168> managePermission, String tool) {
        if (!BlockPerToolCommand.ensurePermission(source, managePermission) || !BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        ConfigService.ChangeResult result = bootstrap.configService().removeBlocksPerToolTool(tool);
        return switch (result) {
            default -> throw new MatchException(null, null);
            case ConfigService.ChangeResult.SUCCESS -> {
                bootstrap.controller().reloadFromConfig();
                source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.tool_removed", tool), true);
                yield 1;
            }
            case ConfigService.ChangeResult.ALREADY_PRESENT, ConfigService.ChangeResult.INVALID, ConfigService.ChangeResult.NOT_FOUND -> {
                source.method_9213(Translations.translate("command.veinminer.blockpertool.tool_not_found", tool));
                yield 0;
            }
        };
    }

    private static int listTools(class_2168 source, Bootstrap bootstrap) {
        if (!BlockPerToolCommand.ensurePerToolMode(source, bootstrap)) {
            return 0;
        }
        NavigableSet<String> tools = bootstrap.configService().getAllToolKeys();
        if (tools == null || tools.isEmpty()) {
            source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.no_tools", new Object[0]), false);
        } else {
            source.method_9226(() -> Translations.translate("command.veinminer.blockpertool.tools_header", new Object[0]), false);
            tools.forEach(tool -> source.method_9226(() -> Translations.translate("command.veinminer.list_entry", tool), false));
        }
        return 1;
    }

    private static SuggestionProvider<class_2168> suggestConfiguredTools(Bootstrap bootstrap) {
        return (ctx, builder) -> BlockPerToolCommand.suggestValues(bootstrap.configService().getAllToolKeys(), builder);
    }

    private static SuggestionProvider<class_2168> suggestAllTools() {
        return (ctx, builder) -> class_2172.method_9265(BlockPerToolCommand.collectToolOptions(), (SuggestionsBuilder)builder);
    }

    private static SuggestionProvider<class_2168> suggestAllBlocksOrTags() {
        return (ctx, builder) -> BlockPerToolCommand.suggestBlocksAndTags(builder);
    }

    private static SuggestionProvider<class_2168> suggestBlocksForTool(Bootstrap bootstrap) {
        return (ctx, builder) -> {
            String tool = "";
            try {
                tool = StringArgumentType.getString((CommandContext)ctx, (String)"tool");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            NavigableSet<String> entries = bootstrap.configService().getBlocksForTool(tool);
            if (entries == null || entries.isEmpty()) {
                return BlockPerToolCommand.suggestBlocksAndTags(builder);
            }
            return class_2172.method_9265(entries, (SuggestionsBuilder)builder);
        };
    }

    private static CompletableFuture<Suggestions> suggestValues(Iterable<String> values, SuggestionsBuilder builder) {
        if (values == null) {
            return builder.buildFuture();
        }
        ArrayList<String> options = new ArrayList<String>();
        for (String value : values) {
            options.add(value);
        }
        if (options.isEmpty()) {
            return builder.buildFuture();
        }
        return class_2172.method_9265(options, (SuggestionsBuilder)builder);
    }

    private static CompletableFuture<Suggestions> suggestBlocksAndTags(SuggestionsBuilder builder) {
        ArrayList<String> options = new ArrayList<String>(class_7923.field_41175.method_10235().size());
        for (class_2960 id : class_7923.field_41175.method_10235()) {
            options.add(id.toString());
        }
        class_7923.field_41175.method_40272().forEach(tag -> {
            String tagId = BlockPerToolCommand.tagId(tag);
            if (tagId != null) {
                options.add("#" + tagId);
            }
        });
        return class_2172.method_9265(options, (SuggestionsBuilder)builder);
    }

    private static List<String> collectToolOptions() {
        ArrayList<String> options = new ArrayList<String>(class_7923.field_41178.method_10235().size() + 1);
        for (class_2960 id : class_7923.field_41178.method_10235()) {
            options.add(id.toString());
        }
        class_7923.field_41178.method_40272().forEach(tag -> {
            String tagId = BlockPerToolCommand.tagId(tag);
            if (tagId != null) {
                options.add("#" + tagId);
            }
        });
        options.add("hand");
        return options;
    }

    private static String tagId(Object tag) {
        Object value;
        if (tag instanceof class_6862) {
            class_6862 tagKey = (class_6862)tag;
            return tagKey.comp_327().toString();
        }
        try {
            Method id = tag.getClass().getMethod("id", new Class[0]);
            value = id.invoke(tag, new Object[0]);
            if (value != null) {
                return value.toString();
            }
        }
        catch (Exception id) {
            // empty catch block
        }
        try {
            Method getTag = tag.getClass().getMethod("getTag", new Class[0]);
            value = getTag.invoke(tag, new Object[0]);
            if (value instanceof class_6862) {
                class_6862 tagKey = (class_6862)value;
                return tagKey.comp_327().toString();
            }
        }
        catch (Exception getTag) {
            // empty catch block
        }
        try {
            Method getTagKey = tag.getClass().getMethod("getTagKey", new Class[0]);
            value = getTagKey.invoke(tag, new Object[0]);
            if (value instanceof class_6862) {
                class_6862 tagKey = (class_6862)value;
                return tagKey.comp_327().toString();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static boolean ensurePerToolMode(class_2168 source, Bootstrap bootstrap) {
        if (bootstrap.configService().general().blockListMode().perTool()) {
            return true;
        }
        source.method_9213(Translations.translate("command.veinminer.blockpertool.not_enabled", new Object[0]));
        return false;
    }

    private static class_2561 describePerToolList(GeneralConfig.BlockListMode mode) {
        String key = mode.blacklist() ? "command.veinminer.block_list_type.per_tool_blacklist" : "command.veinminer.block_list_type.per_tool_whitelist";
        return Translations.translate(key, new Object[0]);
    }

    private static boolean ensurePermission(class_2168 source, Predicate<class_2168> managePermission) {
        if (managePermission.test(source)) {
            return true;
        }
        source.method_9213(Translations.translate("message.veinminer.no_permission", new Object[0]));
        return false;
    }

    private static int showHelp(class_2168 source) {
        source.method_9226(() -> Translations.translate("command.veinminer.help.blockpertool", new Object[0]), false);
        return 1;
    }
}

